/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager.xa;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;

public class JcaXAResourceWrapper
implements XAResource {
    private static final Logger log = Logger.getLogger(JcaXAResourceWrapper.class);
    private final XAResource resource;
    private Boolean overrideSameRM;

    public JcaXAResourceWrapper(XAResource resource, Boolean overrideSameRM) {
        this.resource = resource;
        this.overrideSameRM = overrideSameRM;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.resource.commit(xid, onePhase);
    }

    public void end(Xid xid, int flags) throws XAException {
        this.resource.end(xid, flags);
    }

    public void forget(Xid xid) throws XAException {
        this.resource.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.resource.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xaRes) throws XAException {
        if (this.overrideSameRM != null) {
            return this.overrideSameRM;
        }
        if (xaRes instanceof JcaXAResourceWrapper) {
            JcaXAResourceWrapper jca = (JcaXAResourceWrapper)xaRes;
            xaRes = jca.getUnderlyingXAResource();
        }
        XAResource current = this.getUnderlyingXAResource();
        return current.isSameRM(xaRes);
    }

    public int prepare(Xid xid) throws XAException {
        return this.resource.prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.resource.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        this.resource.rollback(xid);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.resource.setTransactionTimeout(seconds);
    }

    public void start(Xid xid, int flags) throws XAException {
        this.resource.start(xid, flags);
    }

    public XAResource getUnderlyingXAResource() {
        return this.resource;
    }
}

