/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss42;

import java.net.URL;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanProxyCreationException;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.wsf.container.jboss42.WebXMLRewriterImpl;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;

public class WebAppDeploymentAspect
extends DeploymentAspect {
    private static Logger log = Logger.getLogger(WebAppDeploymentAspect.class);
    private WebXMLRewriterImpl webXMLRewriter;

    public void setWebXMLRewriter(WebXMLRewriterImpl serviceEndpointPublisher) {
        this.webXMLRewriter = serviceEndpointPublisher;
    }

    public void create(Deployment dep) {
        URL warURL = (URL)dep.getProperty("org.jboss.ws.webapp.url");
        if (warURL == null) {
            throw new IllegalStateException("Cannot obtain webapp URL");
        }
        log.debug((Object)("publishServiceEndpoint: " + warURL));
        try {
            this.webXMLRewriter.rewriteWebXml(dep);
            DeploymentInfo auxdi = new DeploymentInfo(warURL, null, MBeanServerLocator.locateJBoss());
            DeploymentInfo di = (DeploymentInfo)dep.getAttachment(DeploymentInfo.class);
            if (di != null) {
                auxdi.repositoryConfig = di.getTopRepositoryConfig();
            }
            auxdi.context.put("org.jboss.ws.ejbwebapp", "true");
            this.getMainDeployer().deploy(auxdi);
        }
        catch (Exception ex) {
            WSFDeploymentException.rethrow((Throwable)ex);
        }
    }

    public void destroy(Deployment dep) {
        URL warURL = (URL)dep.getProperty("org.jboss.ws.webapp.url");
        if (warURL == null) {
            log.error((Object)"Cannot obtain warURL");
            return;
        }
        log.debug((Object)("destroyServiceEndpoint: " + warURL));
        try {
            this.getMainDeployer().undeploy(warURL);
        }
        catch (Exception ex) {
            WSFDeploymentException.rethrow((Throwable)ex);
        }
    }

    private MainDeployerMBean getMainDeployer() throws MBeanProxyCreationException {
        MBeanServer server = MBeanServerLocator.locateJBoss();
        MainDeployerMBean mainDeployer = (MainDeployerMBean)MBeanProxy.get(MainDeployerMBean.class, (ObjectName)MainDeployerMBean.OBJECT_NAME, (MBeanServer)server);
        return mainDeployer;
    }
}

