/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.singleton;

import java.security.InvalidParameterException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.ha.singleton.HASingletonControllerMBean;
import org.jboss.ha.singleton.HASingletonSupport;

public class HASingletonController
extends HASingletonSupport
implements HASingletonControllerMBean {
    private ObjectName mSingletonMBean;
    private String mSingletonMBeanStartMethod = "startSingleton";
    private String mSingletonMBeanStopMethod = "stopSingleton";
    private String mSingletonMBeanStartMethodArgument;
    private String mSingletonMBeanStopMethodArgument;
    private static final Object[] NO_ARGS = new Object[0];
    private static final String[] NO_TYPES = new String[0];

    public ObjectName getTargetName() {
        return this.mSingletonMBean;
    }

    public void setTargetName(ObjectName targetObjectName) {
        this.mSingletonMBean = targetObjectName;
    }

    public String getTargetStartMethod() {
        return this.mSingletonMBeanStartMethod;
    }

    public void setTargetStartMethod(String targetStartMethod) throws InvalidParameterException {
        if (targetStartMethod != null) {
            this.mSingletonMBeanStartMethod = targetStartMethod;
        }
    }

    public String getTargetStopMethod() {
        return this.mSingletonMBeanStopMethod;
    }

    public void setTargetStopMethod(String targetStopMethod) throws InvalidParameterException {
        if (targetStopMethod != null) {
            this.mSingletonMBeanStopMethod = targetStopMethod;
        }
    }

    public String getTargetStartMethodArgument() {
        return this.mSingletonMBeanStartMethodArgument;
    }

    public void setTargetStartMethodArgument(String targetStartMethodArgument) {
        this.mSingletonMBeanStartMethodArgument = targetStartMethodArgument;
    }

    public String getTargetStopMethodArgument() {
        return this.mSingletonMBeanStopMethodArgument;
    }

    public void setTargetStopMethodArgument(String targetStopMethodArgument) {
        this.mSingletonMBeanStopMethodArgument = targetStopMethodArgument;
    }

    public void startSingleton() {
        super.startSingleton();
        try {
            this.invokeSingletonMBeanMethod(this.mSingletonMBean, this.mSingletonMBeanStartMethod, this.mSingletonMBeanStartMethodArgument);
        }
        catch (JMException jme) {
            this.log.error((Object)"Controlled Singleton MBean failed to become master", (Throwable)jme);
        }
    }

    public void stopSingleton() {
        super.stopSingleton();
        try {
            this.invokeSingletonMBeanMethod(this.mSingletonMBean, this.mSingletonMBeanStopMethod, this.mSingletonMBeanStopMethodArgument);
        }
        catch (JMException jme) {
            this.log.error((Object)"Controlled Singleton MBean failed to resign from master position", (Throwable)jme);
        }
    }

    protected Object invokeSingletonMBeanMethod(ObjectName target, String operationName, Object param) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (target != null && operationName != null) {
            String[] signature;
            Object[] params;
            if (param != null) {
                params = new Object[]{param};
                signature = new String[]{param.getClass().getName()};
                this.log.debug((Object)("Calling operation: " + operationName + "(" + param + "), on target: '" + target + "'"));
            } else {
                params = NO_ARGS;
                signature = NO_TYPES;
                this.log.debug((Object)("Calling operation: " + operationName + "(), on target: '" + target + "'"));
            }
            return this.server.invoke(target, operationName, params, signature);
        }
        this.log.debug((Object)"No configured target mbean or operation to call");
        return null;
    }
}

