/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.HashMap;
import org.jgroups.Channel;
import org.jgroups.blocks.DistributedHashtable;
import org.jgroups.tests.ChannelTestBase;

public class DistributedHashtableUnitTest
extends ChannelTestBase {
    private static int testCount = 1;
    private DistributedHashtable map1;
    private DistributedHashtable map2;

    public DistributedHashtableUnitTest(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        super.setUp();
        System.out.println("#### Setup Test " + testCount);
        Channel c1 = this.createChannel("A");
        this.map1 = new DistributedHashtable(c1, false, 5000L);
        c1.connect("demo");
        this.map1.start(5000L);
        Channel c2 = this.createChannel("A");
        this.map2 = new DistributedHashtable(c2, false, 5000L);
        c2.connect("demo");
        this.map2.start(5000L);
    }

    public void tearDown() throws Exception {
        this.map1.stop();
        this.map2.stop();
        System.out.println("#### TearDown Test " + testCount + "\n\n");
        ++testCount;
        super.tearDown();
    }

    public void testSize() {
        DistributedHashtableUnitTest.assertEquals((int)0, (int)this.map1.size());
        DistributedHashtableUnitTest.assertEquals((int)this.map2.size(), (int)this.map1.size());
        this.map1.put("key1", "value1");
        DistributedHashtableUnitTest.assertEquals((int)1, (int)this.map1.size());
        DistributedHashtableUnitTest.assertEquals((int)this.map2.size(), (int)this.map1.size());
        this.map2.put("key2", "value2");
        DistributedHashtableUnitTest.assertEquals((int)2, (int)this.map1.size());
        DistributedHashtableUnitTest.assertEquals((int)this.map2.size(), (int)this.map1.size());
    }

    public void testIsEmpty() {
        DistributedHashtableUnitTest.assertTrue((boolean)this.map1.isEmpty());
        DistributedHashtableUnitTest.assertTrue((boolean)this.map2.isEmpty());
        this.map1.put("key", "value");
        DistributedHashtableUnitTest.assertFalse((boolean)this.map1.isEmpty());
        DistributedHashtableUnitTest.assertFalse((boolean)this.map2.isEmpty());
    }

    public void testContainsKey() {
        DistributedHashtableUnitTest.assertFalse((boolean)this.map1.containsKey("key1"));
        DistributedHashtableUnitTest.assertFalse((boolean)this.map2.containsKey("key1"));
        this.map1.put("key1", "value");
        DistributedHashtableUnitTest.assertTrue((boolean)this.map1.containsKey("key1"));
        DistributedHashtableUnitTest.assertTrue((boolean)this.map2.containsKey("key1"));
        this.map2.put("key2", "value");
        DistributedHashtableUnitTest.assertTrue((boolean)this.map1.containsKey("key2"));
        DistributedHashtableUnitTest.assertTrue((boolean)this.map2.containsKey("key2"));
    }

    public void testContainsValue() {
        DistributedHashtableUnitTest.assertFalse((boolean)this.map1.containsValue("value1"));
        DistributedHashtableUnitTest.assertFalse((boolean)this.map2.containsValue("value1"));
        this.map1.put("key1", "value1");
        DistributedHashtableUnitTest.assertTrue((boolean)this.map1.containsValue("value1"));
        DistributedHashtableUnitTest.assertTrue((boolean)this.map2.containsValue("value1"));
        this.map2.put("key2", "value2");
        DistributedHashtableUnitTest.assertTrue((boolean)this.map1.containsValue("value2"));
        DistributedHashtableUnitTest.assertTrue((boolean)this.map2.containsValue("value2"));
    }

    public void testPutAndGet() {
        DistributedHashtableUnitTest.assertNull(this.map1.get("key1"));
        DistributedHashtableUnitTest.assertNull(this.map2.get("key1"));
        this.map1.put("key1", "value1");
        DistributedHashtableUnitTest.assertNotNull(this.map1.get("key1"));
        DistributedHashtableUnitTest.assertNotNull(this.map2.get("key1"));
        this.map2.put("key2", "value2");
        DistributedHashtableUnitTest.assertNotNull(this.map1.get("key2"));
        DistributedHashtableUnitTest.assertNotNull(this.map2.get("key2"));
    }

    public void testRemove() {
        DistributedHashtableUnitTest.assertNull(this.map1.get("key1"));
        DistributedHashtableUnitTest.assertNull(this.map2.get("key1"));
        this.map1.put("key1", "value1");
        this.map2.put("key2", "value2");
        DistributedHashtableUnitTest.assertNotNull(this.map1.get("key1"));
        DistributedHashtableUnitTest.assertNotNull(this.map2.get("key1"));
        DistributedHashtableUnitTest.assertNotNull(this.map1.get("key2"));
        DistributedHashtableUnitTest.assertNotNull(this.map2.get("key2"));
        this.map1.remove("key1");
        DistributedHashtableUnitTest.assertNull(this.map1.get("key1"));
        DistributedHashtableUnitTest.assertNull(this.map2.get("key1"));
        DistributedHashtableUnitTest.assertNotNull(this.map1.get("key2"));
        DistributedHashtableUnitTest.assertNotNull(this.map2.get("key2"));
        this.map2.remove("key2");
        DistributedHashtableUnitTest.assertNull(this.map1.get("key2"));
        DistributedHashtableUnitTest.assertNull(this.map2.get("key2"));
    }

    public void testPutAll() {
        HashMap<String, String> all1 = new HashMap<String, String>();
        all1.put("key1", "value1");
        all1.put("key2", "value2");
        HashMap<String, String> all2 = new HashMap<String, String>();
        all2.put("key3", "value3");
        all2.put("key4", "value4");
        this.map1.putAll(all1);
        DistributedHashtableUnitTest.assertEquals((int)2, (int)this.map1.size());
        DistributedHashtableUnitTest.assertEquals((int)2, (int)this.map2.size());
        this.map2.putAll(all2);
        DistributedHashtableUnitTest.assertEquals((int)4, (int)this.map1.size());
        DistributedHashtableUnitTest.assertEquals((int)4, (int)this.map2.size());
        DistributedHashtableUnitTest.assertTrue((boolean)this.map1.containsKey("key1"));
        DistributedHashtableUnitTest.assertTrue((boolean)this.map1.containsKey("key2"));
        DistributedHashtableUnitTest.assertTrue((boolean)this.map1.containsKey("key3"));
        DistributedHashtableUnitTest.assertTrue((boolean)this.map1.containsKey("key4"));
        DistributedHashtableUnitTest.assertTrue((boolean)this.map2.containsKey("key1"));
        DistributedHashtableUnitTest.assertTrue((boolean)this.map2.containsKey("key2"));
        DistributedHashtableUnitTest.assertTrue((boolean)this.map2.containsKey("key3"));
        DistributedHashtableUnitTest.assertTrue((boolean)this.map2.containsKey("key4"));
    }

    public void testClear() {
        DistributedHashtableUnitTest.assertTrue((boolean)this.map1.isEmpty());
        DistributedHashtableUnitTest.assertTrue((boolean)this.map2.isEmpty());
        this.map1.put("key", "value");
        DistributedHashtableUnitTest.assertFalse((boolean)this.map1.isEmpty());
        DistributedHashtableUnitTest.assertFalse((boolean)this.map2.isEmpty());
        this.map1.clear();
        DistributedHashtableUnitTest.assertTrue((boolean)this.map1.isEmpty());
        DistributedHashtableUnitTest.assertTrue((boolean)this.map2.isEmpty());
        this.map2.put("key", "value");
        DistributedHashtableUnitTest.assertFalse((boolean)this.map1.isEmpty());
        DistributedHashtableUnitTest.assertFalse((boolean)this.map2.isEmpty());
        this.map2.clear();
        DistributedHashtableUnitTest.assertTrue((boolean)this.map1.isEmpty());
        DistributedHashtableUnitTest.assertTrue((boolean)this.map2.isEmpty());
    }

    public void testKeySet() {
        HashMap<String, String> all1 = new HashMap<String, String>();
        all1.put("key1", "value1");
        all1.put("key2", "value2");
        HashMap<String, String> all2 = new HashMap<String, String>();
        all2.put("key3", "value3");
        all2.put("key4", "value4");
        this.map1.putAll(all1);
        DistributedHashtableUnitTest.assertEquals(all1.keySet(), this.map1.keySet());
        DistributedHashtableUnitTest.assertEquals(all1.keySet(), this.map2.keySet());
        this.map2.putAll(all2);
        all1.putAll(all2);
        DistributedHashtableUnitTest.assertEquals(all1.keySet(), this.map1.keySet());
        DistributedHashtableUnitTest.assertEquals(all1.keySet(), this.map2.keySet());
    }

    public void testValues() {
        HashMap<String, String> all1 = new HashMap<String, String>();
        all1.put("key1", "value1");
        all1.put("key2", "value2");
        HashMap<String, String> all2 = new HashMap<String, String>();
        all2.put("key3", "value3");
        all2.put("key4", "value4");
        this.map1.putAll(all1);
        DistributedHashtableUnitTest.assertTrue((boolean)this.map1.values().containsAll(all1.values()));
        DistributedHashtableUnitTest.assertTrue((boolean)this.map2.values().containsAll(all1.values()));
        this.map2.putAll(all2);
        all1.putAll(all2);
        DistributedHashtableUnitTest.assertTrue((boolean)this.map1.values().containsAll(all1.values()));
        DistributedHashtableUnitTest.assertTrue((boolean)this.map2.values().containsAll(all1.values()));
    }
}

