/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.binding.AbstractSerializerFactory;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.binding.SerializerSupport;
import org.jboss.ws.core.binding.TypeMappingImpl;
import org.jboss.ws.core.jaxrpc.binding.NullValueSerializer;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.SOAPContent;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.XMLContent;
import org.jboss.ws.core.soap.XMLFragment;
import org.jboss.wsf.common.JavaUtils;

public class ObjectContent
extends SOAPContent {
    private static Logger log = Logger.getLogger(ObjectContent.class);
    private Object objectValue;

    protected ObjectContent(SOAPContentElement container) {
        super(container);
    }

    SOAPContent.State getState() {
        return SOAPContent.State.OBJECT_VALID;
    }

    SOAPContent transitionTo(SOAPContent.State nextState) {
        SOAPContent next = null;
        if (nextState == SOAPContent.State.XML_VALID) {
            XMLFragment fragment = this.marshallObjectContents();
            XMLContent xmlValid = new XMLContent(this.container);
            xmlValid.setXMLFragment(fragment);
            next = xmlValid;
        } else if (nextState == SOAPContent.State.OBJECT_VALID) {
            next = this;
        } else if (nextState == SOAPContent.State.DOM_VALID) {
            XMLFragment fragment = this.marshallObjectContents();
            XMLContent tmp = new XMLContent(this.container);
            tmp.setXMLFragment(fragment);
            next = tmp.transitionTo(SOAPContent.State.DOM_VALID);
        } else {
            throw new IllegalArgumentException("Illegal state requested: " + (Object)((Object)nextState));
        }
        return next;
    }

    public Source getPayload() {
        throw new IllegalStateException("Payload not available");
    }

    public void setPayload(Source source) {
        throw new IllegalStateException("Payload cannot be set on object content");
    }

    public XMLFragment getXMLFragment() {
        throw new IllegalStateException("XMLFragment not available");
    }

    public void setXMLFragment(XMLFragment xmlFragment) {
        throw new IllegalStateException("XMLFragment not available");
    }

    public Object getObjectValue() {
        return this.objectValue;
    }

    public void setObjectValue(Object objValue) {
        this.objectValue = objValue;
    }

    private XMLFragment marshallObjectContents() {
        QName xmlType = this.container.getXmlType();
        Class javaType = this.container.getJavaType();
        log.debug((Object)("getXMLFragment from Object [xmlType=" + xmlType + ",javaType=" + javaType + "]"));
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext == null) {
            throw new WSException("MessageContext not available");
        }
        SerializationContext serContext = msgContext.getSerializationContext();
        serContext.setJavaType(javaType);
        TypeMappingImpl typeMapping = serContext.getTypeMapping();
        XMLFragment xmlFragment = null;
        try {
            SerializerSupport ser;
            if (this.objectValue != null) {
                AbstractSerializerFactory serializerFactory = this.getSerializerFactory(typeMapping, javaType, xmlType);
                ser = serializerFactory.getSerializer();
            } else {
                ser = new NullValueSerializer();
            }
            Result result = ser.serialize(this.container, serContext);
            xmlFragment = new XMLFragment(result);
            log.debug((Object)("xmlFragment: " + xmlFragment));
        }
        catch (BindingException e) {
            throw new WSException(e);
        }
        return xmlFragment;
    }

    private AbstractSerializerFactory getSerializerFactory(TypeMappingImpl typeMapping, Class javaType, QName xmlType) {
        Class arrayWrapperType;
        AbstractSerializerFactory serializerFactory = (AbstractSerializerFactory)typeMapping.getSerializer(javaType, xmlType);
        if (serializerFactory == null && javaType.isArray() && (arrayWrapperType = typeMapping.getJavaType(xmlType)) != null) {
            try {
                Method toArrayMethod = arrayWrapperType.getMethod("toArray", new Class[0]);
                Class<?> returnType = toArrayMethod.getReturnType();
                if (JavaUtils.isAssignableFrom(javaType, returnType)) {
                    serializerFactory = (AbstractSerializerFactory)typeMapping.getSerializer(arrayWrapperType, xmlType);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (serializerFactory == null) {
            throw new WSException("Cannot obtain serializer factory for: [xmlType=" + xmlType + ",javaType=" + javaType + "]");
        }
        return serializerFactory;
    }
}

