/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.jaxws.impl;

import com.sun.tools.ws.wscompile.WsimportTool;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.ws.tools.io.NullPrintStream;
import org.jboss.wsf.spi.tools.WSContractConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunRIConsumerImpl
extends WSContractConsumer {
    private List<File> bindingFiles;
    private File catalog;
    private boolean extension;
    private boolean generateSource;
    private File outputDir = new File("output");
    private File sourceDir;
    private String targetPackage;
    private PrintStream messageStream;
    private String wsdlLocation;
    private List<String> additionalCompilerClassPath = new ArrayList<String>();
    private String target = "2.0";

    @Override
    public void setBindingFiles(List<File> bindingFiles) {
        this.bindingFiles = bindingFiles;
    }

    @Override
    public void setCatalog(File catalog) {
        this.catalog = catalog;
    }

    @Override
    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    @Override
    public void setGenerateSource(boolean generateSource) {
        this.generateSource = generateSource;
    }

    @Override
    public void setMessageStream(PrintStream messageStream) {
        this.messageStream = messageStream;
    }

    @Override
    public void setOutputDirectory(File directory) {
        this.outputDir = directory;
    }

    @Override
    public void setSourceDirectory(File directory) {
        this.sourceDir = directory;
    }

    @Override
    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    @Override
    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    @Override
    public void setAdditionalCompilerClassPath(List<String> additionalCompilerClassPath) {
        this.additionalCompilerClassPath = additionalCompilerClassPath;
    }

    @Override
    public void setTarget(String target) {
        this.target = target;
    }

    @Override
    public void consume(URL wsdl) {
        PrintStream stream;
        ArrayList<String> args = new ArrayList<String>();
        if (this.bindingFiles != null) {
            for (File file : this.bindingFiles) {
                args.add("-b");
                args.add(file.getAbsolutePath());
            }
        }
        if (this.catalog != null) {
            args.add("-catalog");
            args.add(this.catalog.getAbsolutePath());
        }
        if (this.extension) {
            args.add("-extension");
        }
        if (this.generateSource) {
            args.add("-keep");
            if (this.sourceDir != null) {
                if (!this.sourceDir.exists() && !this.sourceDir.mkdirs()) {
                    throw new IllegalStateException("Could not make directory: " + this.sourceDir.getName());
                }
                args.add("-s");
                args.add(this.sourceDir.getAbsolutePath());
            }
        }
        if (this.targetPackage != null) {
            args.add("-p");
            args.add(this.targetPackage);
        }
        if (this.wsdlLocation != null) {
            args.add("-wsdllocation");
            args.add(this.wsdlLocation);
        }
        if ((stream = this.messageStream) != null) {
            args.add("-verbose");
        } else {
            stream = NullPrintStream.getInstance();
        }
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new IllegalStateException("Could not make directory: " + this.outputDir.getName());
        }
        args.add("-d");
        args.add(this.outputDir.getAbsolutePath());
        if (!this.target.equals("2.0")) {
            throw new IllegalArgumentException("WSConsume (native) only supports JAX-WS 2.0");
        }
        args.add("-target");
        args.add(this.target);
        args.add(wsdl.toString());
        if (!this.additionalCompilerClassPath.isEmpty()) {
            StringBuffer javaCP = new StringBuffer();
            for (String s : this.additionalCompilerClassPath) {
                javaCP.append(s).append(File.pathSeparator);
            }
            System.setProperty("java.class.path", javaCP.toString());
        }
        try {
            WsimportTool compileTool;
            boolean success;
            if (null == System.getProperty("javax.xml.stream.XMLInputFactory")) {
                System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
            }
            if (!(success = (compileTool = new WsimportTool((OutputStream)stream)).run(args.toArray(new String[args.size()])))) {
                throw new IllegalStateException("WsImport invocation failed. Try the verbose switch for more information");
            }
        }
        catch (Throwable t) {
            if (this.messageStream != null) {
                this.messageStream.println("Failed to invoke WsImport");
                t.printStackTrace(this.messageStream);
            }
            t.printStackTrace();
        }
    }
}

