/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws;

import com.sun.xml.bind.api.JAXBRIContext;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.jaxb.intros.IntroductionsAnnotationReader;
import org.jboss.jaxb.intros.IntroductionsConfigParser;
import org.jboss.jaxb.intros.configmodel.JaxbIntros;
import org.jboss.logging.Logger;
import org.jboss.ws.core.jaxws.JAXBBindingCustomization;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class JAXBIntroDeploymentAspect
extends DeploymentAspect {
    private static Logger logger = Logger.getLogger(JAXBIntroDeploymentAspect.class);
    private static final String META_INF_JAXB_INTROS_XML = "META-INF/jaxb-intros.xml";
    private static final String WEB_INF_JAXB_INTROS_XML = "WEB-INF/jaxb-intros.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void create(Deployment deployment) {
        UnifiedVirtualFile vfs;
        if (!(deployment instanceof ArchiveDeployment)) {
            this.log.debug((Object)("JAXBIntroDeploymentAspect doesn't work on " + deployment.getClass()));
            return;
        }
        ArchiveDeployment archive = (ArchiveDeployment)deployment;
        InputStream introsConfigStream = null;
        try {
            vfs = archive.getRootFile().findChild(META_INF_JAXB_INTROS_XML);
            introsConfigStream = vfs.toURL().openStream();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (null == introsConfigStream) {
            try {
                vfs = archive.getRootFile().findChild(WEB_INF_JAXB_INTROS_XML);
                introsConfigStream = vfs.toURL().openStream();
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            if (introsConfigStream != null) {
                JaxbIntros jaxbIntros = IntroductionsConfigParser.parseConfig((InputStream)introsConfigStream);
                IntroductionsAnnotationReader annotationReader = new IntroductionsAnnotationReader(jaxbIntros);
                String defaultNamespace = jaxbIntros.getDefaultNamespace();
                JAXBBindingCustomization jaxbCustomizations = new JAXBBindingCustomization();
                jaxbCustomizations.put(JAXBRIContext.ANNOTATION_READER, annotationReader);
                if (defaultNamespace != null) {
                    jaxbCustomizations.put("com.sun.xml.bind.defaultNamespaceRemap", defaultNamespace);
                }
                for (Endpoint endpoint : deployment.getService().getEndpoints()) {
                    endpoint.addAttachment(BindingCustomization.class, jaxbCustomizations);
                }
            }
            Object var11_12 = null;
            if (introsConfigStream == null) return;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (introsConfigStream == null) throw throwable;
            try {
                introsConfigStream.close();
                throw throwable;
            }
            catch (IOException e) {
                logger.error((Object)("[" + deployment.getService().getContextRoot() + "] Error closing JAXB Introductions Configurations stream "), (Throwable)e);
            }
            throw throwable;
        }
        try {
            introsConfigStream.close();
            return;
        }
        catch (IOException e) {
            logger.error((Object)("[" + deployment.getService().getContextRoot() + "] Error closing JAXB Introductions Configurations stream "), (Throwable)e);
        }
    }
}

