/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut.ast;

import java.util.ArrayList;
import org.jboss.aop.pointcut.ast.ASTAllParameter;
import org.jboss.aop.pointcut.ast.ASTAttribute;
import org.jboss.aop.pointcut.ast.ASTException;
import org.jboss.aop.pointcut.ast.ASTParameter;
import org.jboss.aop.pointcut.ast.ClassExpression;
import org.jboss.aop.pointcut.ast.IdentifierExpression;
import org.jboss.aop.pointcut.ast.Node;
import org.jboss.aop.pointcut.ast.PointcutExpressionParser;
import org.jboss.aop.pointcut.ast.PointcutExpressionParserVisitor;
import org.jboss.aop.pointcut.ast.SimpleNode;
import org.jboss.aop.pointcut.ast.TypeExpressionParserVisitor;

public class ASTConstructor
extends SimpleNode {
    String classExpr;
    ClassExpression clazz;
    IdentifierExpression annotation;
    ArrayList attributes = new ArrayList();
    ArrayList parameters = new ArrayList();
    boolean anyParameters = false;
    boolean hasAnyZeroOrMoreParameters = false;
    ArrayList exceptions = new ArrayList();

    public ASTConstructor(int id) {
        super(id);
    }

    public ASTConstructor(PointcutExpressionParser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(PointcutExpressionParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object jjtAccept(TypeExpressionParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void jjtAddChild(Node n, int i) {
        if (n instanceof ASTAttribute) {
            this.attributes.add(n);
        } else if (n instanceof ASTException) {
            this.exceptions.add(n);
        } else if (n instanceof ASTAllParameter) {
            this.anyParameters = true;
        } else if (n instanceof ASTParameter && !this.anyParameters) {
            this.parameters.add(0, n);
            if (!this.hasAnyZeroOrMoreParameters && ((ASTParameter)n).isAnyZeroOrMoreParameters()) {
                this.hasAnyZeroOrMoreParameters = true;
            }
        } else {
            super.jjtAddChild(n, i);
        }
    }

    public void setClassExpression(String expression) {
        this.classExpr = expression;
        this.clazz = new ClassExpression(this.classExpr);
    }

    public void setNewExpression(String expr) {
        if (expr.startsWith("@")) {
            this.annotation = new IdentifierExpression(expr);
        }
    }

    public String getClassExpr() {
        return this.classExpr;
    }

    public ArrayList getAttributes() {
        return this.attributes;
    }

    public ArrayList getExceptions() {
        return this.exceptions;
    }

    public ArrayList getParameters() {
        return this.parameters;
    }

    public boolean isAnyParameters() {
        return this.anyParameters;
    }

    public boolean hasAnyZeroOrMoreParameters() {
        return this.hasAnyZeroOrMoreParameters;
    }

    public ClassExpression getClazz() {
        return this.clazz;
    }

    public IdentifierExpression getConstructorAnnotation() {
        return this.annotation;
    }
}

