/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.jdbc.JDBCAccess;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

public abstract class JDBCImple {
    private int shareStatus;
    private Hashtable stateCache = new Hashtable();
    protected JDBCAccess _jdbcAccess = null;
    protected Connection[] _theConnection = null;
    protected boolean _isValid = false;
    protected PreparedStatement[][] _preparedStatements = null;
    protected static final int COMMIT_STATE = 0;
    protected static final int HIDE_STATE = 1;
    protected static final int REVEAL_STATE = 2;
    protected static final int CURRENT_STATE = 3;
    protected static final int READ_STATE = 4;
    protected static final int REMOVE_STATE = 5;
    protected static final int WRITE_STATE_NEW = 6;
    protected static final int WRITE_STATE_EXISTING = 7;
    protected static final int SELECT_FOR_WRITE_STATE = 8;
    protected static final int READ_WRITE_SHORTCUT = 9;
    protected static final int PRECOMMIT_CLEANUP = 10;
    protected static final int STATEMENT_SIZE = 11;
    protected boolean[] _inUse = null;
    protected int _poolSizeInit = 1;
    protected int _poolSizeMax = 1;
    protected boolean _poolPutConn = false;

    public final boolean storeValid() {
        return this._isValid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean commit_state(Uid objUid, String typeName, String tableName) throws ObjectStoreException {
        boolean result = false;
        boolean cleanup = true;
        if (!this.storeValid()) {
            return false;
        }
        if (typeName == null) throw new ObjectStoreException("commit_state - object with uid " + objUid + " has no TypeName");
        int currState = this.currentState(objUid, typeName, tableName);
        int pool = this.getPool();
        try {
            PreparedStatement pstmt = this._preparedStatements[pool][10];
            if (pstmt == null) {
                this._preparedStatements[pool][10] = pstmt = this._theConnection[pool].prepareStatement("DELETE FROM " + tableName + " WHERE UidString = ? AND TypeName = ? AND StateType = " + 1);
            }
            pstmt.setString(1, objUid.stringForm());
            pstmt.setString(2, typeName);
            pstmt.executeUpdate();
            pstmt = this._preparedStatements[pool][0];
            if (pstmt == null) {
                this._preparedStatements[pool][0] = pstmt = this._theConnection[pool].prepareStatement("UPDATE " + tableName + " SET StateType = ? WHERE UidString = ? AND TypeName = ? AND StateType = ?");
            }
            if (currState == 2) {
                pstmt.setInt(1, 1);
            } else {
                if (currState != 6) throw new ObjectStoreException("can't commit object " + objUid + " in state " + currState);
                pstmt.setInt(1, 5);
            }
            pstmt.setString(2, objUid.stringForm());
            pstmt.setString(3, typeName);
            pstmt.setInt(4, currState);
            int rowcount = pstmt.executeUpdate();
            if (rowcount <= 0) return result;
            result = true;
            return result;
        }
        catch (Throwable e) {
            cleanup = false;
            if (!this.retryConnection(e, pool)) throw new ObjectStoreException(e.toString());
            boolean bl = this.commit_state(objUid, typeName, tableName);
            return bl;
        }
        finally {
            if (cleanup) {
                this.freePool(pool);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hide_state(Uid objUid, String typeName, String tableName) throws ObjectStoreException {
        boolean hiddenOk = true;
        boolean cleanup = true;
        if (!this.storeValid()) return false;
        int state = this.currentState(objUid, typeName, tableName);
        int pool = this.getPool();
        PreparedStatement pstmt = null;
        try {
            pstmt = this._preparedStatements[pool][1];
            if (pstmt == null) {
                this._preparedStatements[pool][1] = pstmt = this._theConnection[pool].prepareStatement("UPDATE " + tableName + " SET StateType = ? WHERE UidString = ? AND TypeName = ? AND StateType = ?");
            }
        }
        catch (Exception e) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_1", new Object[]{e});
            }
            this.freePool(pool);
            return false;
        }
        try {
            switch (state) {
                case 5: 
                case 6: {
                    return hiddenOk;
                }
                case 2: {
                    pstmt.setInt(1, 6);
                    pstmt.setString(2, objUid.stringForm());
                    pstmt.setString(3, typeName);
                    pstmt.setInt(4, state);
                    pstmt.executeUpdate();
                    return hiddenOk;
                }
                case 1: {
                    pstmt.setInt(1, 5);
                    pstmt.setString(2, objUid.stringForm());
                    pstmt.setString(3, typeName);
                    pstmt.setInt(4, state);
                    pstmt.executeUpdate();
                    return hiddenOk;
                }
                default: {
                    hiddenOk = false;
                    return hiddenOk;
                }
            }
        }
        catch (Throwable e) {
            cleanup = false;
            if (!this.retryConnection(e, pool)) throw new ObjectStoreException(e.toString());
            this.hide_state(objUid, typeName, tableName);
            return hiddenOk;
        }
        finally {
            if (cleanup) {
                this.freePool(pool);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean reveal_state(Uid objUid, String typeName, String tableName) throws ObjectStoreException {
        boolean revealedOk = true;
        boolean cleanup = true;
        if (!this.storeValid()) return false;
        int state = this.currentState(objUid, typeName, tableName);
        int pool = this.getPool();
        PreparedStatement pstmt = null;
        try {
            pstmt = this._preparedStatements[pool][2];
            if (pstmt == null) {
                this._preparedStatements[pool][2] = pstmt = this._theConnection[pool].prepareStatement("UPDATE " + tableName + " SET StateType = ? WHERE UidString = ? AND AND TypeName = ? StateType = ?");
            }
        }
        catch (Exception e) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_2", new Object[]{e});
            }
            this.freePool(pool);
            return false;
        }
        try {
            switch (state) {
                case 6: {
                    pstmt.setInt(1, 2);
                    pstmt.setString(2, objUid.stringForm());
                    pstmt.setString(3, typeName);
                    pstmt.setInt(4, state);
                    pstmt.executeUpdate();
                    return revealedOk;
                }
                case 5: {
                    pstmt.setInt(1, 1);
                    pstmt.setString(2, objUid.stringForm());
                    pstmt.setString(3, typeName);
                    pstmt.setInt(4, state);
                    pstmt.executeUpdate();
                    return revealedOk;
                }
                case 1: 
                case 2: {
                    return revealedOk;
                }
                default: {
                    revealedOk = false;
                    return revealedOk;
                }
            }
        }
        catch (Throwable e) {
            cleanup = false;
            if (!this.retryConnection(e, pool)) throw new ObjectStoreException(e.toString());
            this.reveal_state(objUid, typeName, tableName);
            return revealedOk;
        }
        finally {
            if (cleanup) {
                this.freePool(pool);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int currentState(Uid objUid, String typeName, String tableName) throws ObjectStoreException {
        int theState;
        block33: {
            theState = 0;
            ResultSet rs = null;
            boolean cleanup = true;
            if (this.storeValid()) {
                int pool;
                block32: {
                    pool = this.getPool();
                    PreparedStatement pstmt = this._preparedStatements[pool][3];
                    if (pstmt == null) {
                        this._preparedStatements[pool][3] = pstmt = this._theConnection[pool].prepareStatement("SELECT StateType, UidString FROM " + tableName + " WHERE UidString = ? AND TypeName = ?");
                    }
                    pstmt.setString(1, objUid.stringForm());
                    pstmt.setString(2, typeName);
                    rs = pstmt.executeQuery();
                    boolean have_OS_UNCOMMITTED = false;
                    boolean have_OS_UNCOMMITTED_HIDDEN = false;
                    boolean have_OS_COMMITTED = false;
                    boolean have_OS_COMMITTED_HIDDEN = false;
                    while (rs.next()) {
                        int stateStatus = rs.getInt(1);
                        switch (stateStatus) {
                            case 2: {
                                have_OS_UNCOMMITTED = true;
                                break;
                            }
                            case 1: {
                                have_OS_COMMITTED = true;
                                break;
                            }
                            case 5: {
                                have_OS_COMMITTED_HIDDEN = true;
                                break;
                            }
                            case 6: {
                                have_OS_UNCOMMITTED_HIDDEN = true;
                            }
                        }
                    }
                    if (have_OS_COMMITTED_HIDDEN) {
                        theState = 5;
                    }
                    if (have_OS_COMMITTED) {
                        theState = 1;
                    }
                    if (have_OS_UNCOMMITTED_HIDDEN) {
                        theState = 6;
                    }
                    if (!have_OS_UNCOMMITTED) break block32;
                    theState = 2;
                }
                Object var15_18 = null;
                if (!cleanup) break block33;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                this.freePool(pool);
                {
                    break block33;
                    catch (Throwable e) {
                        int n;
                        block36: {
                            cleanup = false;
                            try {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                            catch (SQLException re) {
                                // empty catch block
                            }
                            if (this.retryConnection(e, pool)) {
                                int n2 = this.currentState(objUid, typeName, tableName);
                                Object var15_19 = null;
                                if (cleanup) {
                                    try {
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                    catch (SQLException e2) {
                                        // empty catch block
                                    }
                                    this.freePool(pool);
                                }
                                return n2;
                            }
                            try {
                                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_3", new Object[]{e});
                                n = 0;
                                Object var15_20 = null;
                                if (!cleanup) break block36;
                            }
                            catch (Throwable throwable) {
                                Object var15_21 = null;
                                if (cleanup) {
                                    try {
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                    catch (SQLException e2) {
                                        // empty catch block
                                    }
                                    this.freePool(pool);
                                }
                                throw throwable;
                            }
                            try {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                            catch (SQLException e2) {
                                // empty catch block
                            }
                            this.freePool(pool);
                        }
                        return n;
                    }
                }
            }
        }
        return theState;
    }

    /*
     * Exception decompiling
     */
    public boolean allObjUids(String typeName, InputObjectState state, int match, String tableName) throws ObjectStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean allTypes(InputObjectState foundTypes, String tableName) throws ObjectStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean remove_state(Uid objUid, String name, int ft, String tableName) throws ObjectStoreException {
        boolean removeOk = false;
        boolean cleanup = true;
        if (!this.storeValid()) {
            return false;
        }
        if (name != null) {
            if (ft == 1 || ft == 2) {
                int pool = this.getPool();
                try {
                    PreparedStatement pstmt = this._preparedStatements[pool][5];
                    if (pstmt == null) {
                        this._preparedStatements[pool][5] = pstmt = this._theConnection[pool].prepareStatement("DELETE FROM " + tableName + " WHERE UidString = ? AND TypeName = ? AND StateType = ?");
                    }
                    pstmt.setString(1, objUid.stringForm());
                    pstmt.setString(2, name);
                    pstmt.setInt(3, ft);
                    if (pstmt.executeUpdate() <= 0) return removeOk;
                    removeOk = true;
                    return removeOk;
                }
                catch (Throwable e) {
                    cleanup = false;
                    if (this.retryConnection(e, pool)) {
                        boolean bl = this.remove_state(objUid, name, ft, tableName);
                        return bl;
                    }
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_8", new Object[]{e});
                    }
                    removeOk = false;
                    return removeOk;
                }
                finally {
                    if (cleanup) {
                        this.freePool(pool);
                    }
                }
            } else {
                removeOk = false;
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) return removeOk;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_9", new Object[]{new Integer(ft), objUid});
            }
            return removeOk;
        } else {
            removeOk = false;
            if (!tsLogger.arjLoggerI18N.isWarnEnabled()) return removeOk;
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_10", new Object[]{objUid});
        }
        return removeOk;
    }

    public abstract InputObjectState read_state(Uid var1, String var2, int var3, String var4) throws ObjectStoreException;

    public abstract boolean write_state(Uid var1, String var2, OutputObjectState var3, int var4, String var5) throws ObjectStoreException;

    public boolean initialise(Connection conn, JDBCAccess jdbcAccess, String tableName) throws SQLException {
        int i;
        block27: {
            String poolSizeMaxStr;
            block26: {
                String poolSizeInitStr = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.jdbcPoolSizeInitial");
                poolSizeMaxStr = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.jdbcPoolSizeMaximum");
                if (poolSizeInitStr != null) {
                    try {
                        this._poolSizeInit = Integer.parseInt(poolSizeInitStr);
                        if (this._poolSizeInit < 1) {
                            this._poolSizeInit = 1;
                            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_11", new Object[]{poolSizeInitStr});
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block26;
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_11", new Object[]{poolSizeInitStr});
                    }
                }
            }
            if (poolSizeMaxStr != null) {
                try {
                    this._poolSizeMax = Integer.parseInt(poolSizeMaxStr);
                    if (this._poolSizeMax < this._poolSizeInit) {
                        this._poolSizeMax = this._poolSizeInit;
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_12", new Object[]{poolSizeMaxStr});
                        }
                    }
                }
                catch (Exception e) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block27;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_12", new Object[]{poolSizeMaxStr});
                }
            }
        }
        this._poolPutConn = "yes".equalsIgnoreCase(arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.jdbcPoolPutConnections"));
        this._jdbcAccess = jdbcAccess;
        this._theConnection = new Connection[this._poolSizeMax];
        this._theConnection[0] = conn;
        try {
            for (i = 1; i < this._poolSizeInit; ++i) {
                this._theConnection[i] = this._jdbcAccess.getConnection();
                this._theConnection[i].setAutoCommit(true);
            }
        }
        catch (Exception e) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_13", new Object[]{e});
            }
            this._isValid = false;
            return this._isValid;
        }
        for (i = this._poolSizeInit; i < this._poolSizeMax; ++i) {
            this._theConnection[i] = null;
        }
        if (this._inUse == null) {
            this._inUse = new boolean[this._poolSizeMax];
        }
        this._preparedStatements = new PreparedStatement[this._poolSizeMax][];
        for (i = 0; i < this._poolSizeMax; ++i) {
            this._preparedStatements[i] = new PreparedStatement[11];
            for (int j = 0; j < 11; ++j) {
                this._preparedStatements[i][j] = null;
            }
        }
        try {
            Statement stmt = this._theConnection[0].createStatement();
            if (jdbcAccess.dropTable()) {
                try {
                    stmt.executeUpdate("DROP TABLE " + tableName);
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
            try {
                this.createTable(stmt, tableName);
            }
            catch (SQLException ex) {
                // empty catch block
            }
            this._isValid = true;
        }
        catch (Exception e) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_13", new Object[]{e});
            }
            this._isValid = false;
        }
        return this._isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTable(String tableName) throws Exception {
        int pool = this.getPool();
        Statement stmt = this._theConnection[pool].createStatement();
        try {
            this.createTable(stmt, tableName);
        }
        catch (SQLException ex) {
        }
        finally {
            this.freePool(pool);
        }
    }

    protected abstract void createTable(Statement var1, String var2) throws SQLException;

    public abstract String name();

    protected final int getState(String state) {
        block3: {
            try {
                Integer st = (Integer)this.stateCache.get(state);
                if (st != null) {
                    return st;
                }
            }
            catch (Exception ex) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block3;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_14", new Object[]{ex});
            }
        }
        return 0;
    }

    protected final void addToCache(Uid state, int status) {
        if (this.shareStatus == 14) {
            this.stateCache.put(state, new Integer(status));
        }
    }

    protected final void removeFromCache(String state) {
        this.removeFromCache(state, true);
    }

    protected final void removeFromCache(String state, boolean warn) {
        if (this.shareStatus == 14 && this.stateCache.remove(state) == null && warn && tsLogger.arjLoggerI18N.isWarnEnabled()) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_15", new Object[]{state});
        }
    }

    final void setShareStatus(int status) {
        this.shareStatus = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean retryConnection(Throwable e, int pool) {
        if (e instanceof SQLException) {
            try {
                this.reconnect(pool);
            }
            catch (Exception e1) {
                return false;
            }
            boolean[] blArray = this._inUse;
            synchronized (this._inUse) {
                this._inUse[pool] = true;
                // ** MonitorExit[var3_4] (shouldn't be in output)
                this.freePool(pool);
                return true;
            }
        }
        return false;
    }

    protected void reconnect(int pool) throws SQLException {
        Connection newConnection = this._theConnection[pool];
        this._theConnection[pool] = null;
        try {
            newConnection.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        this._jdbcAccess.putConnection(newConnection);
        for (int i = 0; i < 11; ++i) {
            this._preparedStatements[pool][i] = null;
        }
        newConnection = this._jdbcAccess.getConnection();
        try {
            newConnection.setAutoCommit(true);
        }
        catch (SQLException e) {
            newConnection = null;
            throw e;
        }
        this._theConnection[pool] = newConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPool() {
        int i = 0;
        int rtn = -1;
        boolean[] blArray = this._inUse;
        synchronized (this._inUse) {
            while (true) {
                if (!this._inUse[i]) {
                    if (this._theConnection[i] == null) {
                        try {
                            this._theConnection[i] = this._jdbcAccess.getConnection();
                            this._inUse[i] = true;
                            rtn = i;
                            break;
                        }
                        catch (Exception e) {
                            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_16", new Object[]{e});
                            }
                        }
                    } else {
                        this._inUse[i] = true;
                        rtn = i;
                        break;
                    }
                }
                if (++i != this._poolSizeMax) continue;
                i = 0;
                try {
                    this._inUse.wait();
                }
                catch (InterruptedException ie) {
                    if (!tsLogger.arjLoggerI18N.isInfoEnabled()) continue;
                    tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_17");
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return rtn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freePool(int pool) {
        boolean[] blArray = this._inUse;
        synchronized (this._inUse) {
            if (!this._inUse[pool] && tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.JDBCImple_18");
            }
            this._inUse[pool] = false;
            this._inUse.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

