/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.net.URI;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.Transaction;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.AbstractInvocationContext;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.DiscoveryEJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.EJBSessionCreationInvocationContext;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.annotation.ClientInterceptorPriority;
import org.jboss.ejb.client.annotation.ClientTransactionPolicy;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.RemoteTransaction;

@ClientInterceptorPriority(value=-200000)
public final class TransactionInterceptor
implements EJBClientInterceptor {
    private static final ContextTransactionManager transactionManager = ContextTransactionManager.getInstance();
    static final Object RESOURCE_KEY = new Object();
    static final AttachmentKey<Collection<URI>> PREFERRED_DESTINATIONS = new AttachmentKey();
    static final AttachmentKey<ConcurrentMap<Application, URI>> APPLICATIONS = new AttachmentKey();
    public static final int PRIORITY = -200000;

    private static URI getApplicationAssociation(ConcurrentMap<Application, URI> applications, AbstractInvocationContext context) {
        return (URI)applications.get(TransactionInterceptor.toApplication(context.getLocator().getIdentifier()));
    }

    static Application toApplication(EJBIdentifier id) {
        return new Application(id.getAppName(), id.getDistinctName());
    }

    private static ConcurrentMap<Application, URI> getOrCreateApplicationMap(AbstractTransaction transaction) {
        Object resource = transaction.getResource(RESOURCE_KEY);
        ConcurrentHashMap<Application, URI> map = null;
        if (resource == null) {
            map = new ConcurrentHashMap<Application, URI>();
            resource = transaction.putResourceIfAbsent(RESOURCE_KEY, map);
        }
        return resource == null ? map : (ConcurrentMap)ConcurrentMap.class.cast(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionID handleSessionCreation(EJBSessionCreationInvocationContext context) throws Exception {
        AbstractTransaction transaction = context.getTransaction();
        if (transaction == null) {
            transaction = transactionManager.getTransaction();
            context.setTransaction(transaction);
        }
        this.setupStickinessIfRequired(context, true, transaction);
        AbstractTransaction old = transactionManager.suspend();
        try {
            SessionID sessionID = context.proceed();
            return sessionID;
        }
        finally {
            transactionManager.resume((Transaction)old);
        }
    }

    private void setupSessionAffinitiesIfNeeded(AbstractInvocationContext context) {
        if (context instanceof EJBSessionCreationInvocationContext) {
            DiscoveryEJBClientInterceptor.setupSessionAffinities((EJBSessionCreationInvocationContext)context);
        }
    }

    private void setupStickinessIfRequired(AbstractInvocationContext context, boolean propagate, AbstractTransaction transaction) {
        ConcurrentMap<Application, URI> applications = null;
        if (transaction instanceof RemoteTransaction) {
            URI location = ((RemoteTransaction)transaction).getLocation();
            if (location != null) {
                context.setDestination(location);
                this.setupSessionAffinitiesIfNeeded(context);
            }
        } else if (transaction instanceof LocalTransaction && propagate) {
            applications = TransactionInterceptor.getOrCreateApplicationMap(transaction);
            URI destination = TransactionInterceptor.getApplicationAssociation(applications, context);
            if (destination != null) {
                context.setDestination(destination);
                this.setupSessionAffinitiesIfNeeded(context);
            } else {
                if (applications.size() > 0) {
                    context.putAttachment(PREFERRED_DESTINATIONS, applications.values());
                }
                context.putAttachment(APPLICATIONS, applications);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInvocation(EJBClientInvocationContext context) throws Exception {
        ClientTransactionPolicy transactionPolicy = context.getTransactionPolicy();
        AbstractTransaction transaction = context.getTransaction();
        if (transaction == null) {
            transaction = transactionManager.getTransaction();
        }
        this.setupStickinessIfRequired(context, transactionPolicy.propagate(), transaction);
        if (transactionPolicy.failIfTransactionAbsent() && transaction == null) {
            throw Logs.TXN.txNotActiveForThread();
        }
        if (transactionPolicy.failIfTransactionPresent() && transaction != null) {
            throw Logs.TXN.txAlreadyAssociatedWithThread();
        }
        if (transactionPolicy.propagate()) {
            context.setTransaction(transaction);
        }
        AbstractTransaction old = transactionManager.suspend();
        try {
            context.sendRequest();
        }
        finally {
            transactionManager.resume((Transaction)old);
        }
    }

    @Override
    public Object handleInvocationResult(EJBClientInvocationContext context) throws Exception {
        return context.getResult();
    }

    static final class Application {
        private String application;
        private String distinctName;

        public Application(String application, String distinctName) {
            this.application = application;
            this.distinctName = distinctName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Application)) {
                return false;
            }
            Application that = (Application)o;
            return this.application.equals(that.application) && this.distinctName.equals(that.distinctName);
        }

        public int hashCode() {
            int result = this.application.hashCode();
            result = 31 * result + this.distinctName.hashCode();
            return result;
        }
    }
}

