/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.net.URI;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.ejb.client.URIAffinity;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.remoting3.Connection;

final class ProtocolV3ObjectResolver
implements ObjectResolver {
    private final NodeAffinity peerNodeAffinity;
    private final NodeAffinity selfNodeAffinity;
    private final URIAffinity peerUriAffinity;
    private final boolean preferUri;

    ProtocolV3ObjectResolver(Connection connection, boolean preferUri) {
        String remoteEndpointName = connection.getRemoteEndpointName();
        this.peerNodeAffinity = remoteEndpointName == null ? null : new NodeAffinity(remoteEndpointName);
        String localEndpointName = connection.getEndpoint().getName();
        this.selfNodeAffinity = localEndpointName == null ? null : new NodeAffinity(localEndpointName);
        this.preferUri = preferUri;
        URI peerURI = connection.getPeerURI();
        this.peerUriAffinity = peerURI == null ? null : (URIAffinity)Affinity.forUri(peerURI);
    }

    public Object readResolve(Object replacement) {
        if (replacement == Affinity.LOCAL) {
            return this.preferUri && this.peerUriAffinity != null ? this.peerUriAffinity : (this.peerNodeAffinity != null ? this.peerNodeAffinity : Affinity.NONE);
        }
        if (replacement instanceof NodeAffinity) {
            if (this.selfNodeAffinity != null && replacement.equals(this.selfNodeAffinity)) {
                return Affinity.LOCAL;
            }
            if (this.preferUri && this.peerUriAffinity != null && this.peerNodeAffinity != null && replacement.equals(this.peerNodeAffinity)) {
                return this.peerUriAffinity;
            }
        }
        return replacement;
    }

    public Object writeReplace(Object original) {
        if (original == Affinity.LOCAL && this.selfNodeAffinity != null) {
            return this.selfNodeAffinity;
        }
        if (this.peerUriAffinity != null && original instanceof URIAffinity && original.equals(this.peerUriAffinity) && this.peerNodeAffinity != null) {
            return this.peerNodeAffinity;
        }
        return original;
    }
}

