/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.reflect.plugins.bytecode;

import java.util.HashMap;

import org.jboss.reflect.plugins.AnnotationAttributeImpl;
import org.jboss.reflect.plugins.AnnotationInfoImpl;
import org.jboss.reflect.plugins.bytecode.bytes.ClassBytes;
import org.jboss.reflect.spi.AnnotationAttribute;
import org.jboss.reflect.spi.AnnotationInfo;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 103926 $
 */
public class BytecodeAnnotationInfo extends BytecodeTypeInfo implements AnnotationInfo
{
   /** serialVersionUID */
   private static final long serialVersionUID = 3546645408219542832L;
   
   /** The attributes */
   protected volatile AnnotationAttribute[] attributes;
   
   /** Attribute Map<String, AnnotationAttribute> */
   protected volatile HashMap<String, AnnotationAttribute> attributeMap;

   public BytecodeAnnotationInfo(BytecodeTypeInfoFactoryImpl factory, String name, ClassBytes classBytes, Class<? extends Object> clazz)
   {
      super(factory, name, classBytes, clazz);
   }

   /**
    * Set the attributes
    * 
    * @param attributes the attributes
    */
   public void setAttributes(AnnotationAttributeImpl[] attributes)
   {
      this.attributes = attributes;
      if (attributes != null && attributes.length > 0)
      {
         this.attributes = attributes;
         attributeMap = new HashMap<String, AnnotationAttribute>(attributes.length);
         for (int i = 0; i < attributes.length; i++)
         {
            attributeMap.put(attributes[i].getName(), attributes[i]);
         }
      }
   }

   public AnnotationAttribute[] getAttributes()
   {
      return attributes;
   }

   public AnnotationAttribute getAttribute(String name)
   {
      if (attributeMap == null)
         return null;
      return attributeMap.get(name);
   }

   @Override
   public boolean equals(Object o)
   {
      if (this == o) return true;
      if (!(o instanceof AnnotationInfoImpl)) return false;

      final AnnotationInfoImpl annotationInfo = (AnnotationInfoImpl) o;

      if (!getName().equals(annotationInfo.getName())) return false;

      return true;
   }

   @Override
   public int hashCode()
   {
      return getName().hashCode();
   }
   
}
