/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jboss.virtual.plugins.context.AbstractURLHandler;
import org.jboss.virtual.plugins.context.jar.JarEntryHandler;
import org.jboss.virtual.plugins.context.jar.SynthenticDirEntryHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

public abstract class AbstractJarHandler
extends AbstractURLHandler {
    private static final long serialVersionUID = 1L;
    private transient JarFile jar;
    private transient ZipEntry entry;

    protected AbstractJarHandler(VFSContext context, VirtualFileHandler parent, URL url, JarFile jar, ZipEntry entry, String name) throws IOException {
        super(context, parent, url, name);
        this.jar = jar;
        this.entry = entry;
    }

    public JarFile getJar() {
        if (this.jar == null) {
            throw new IllegalArgumentException("Null jar");
        }
        return this.jar;
    }

    public ZipEntry getEntry() {
        this.checkClosed();
        if (this.entry == null) {
            throw new IllegalArgumentException("Null entry");
        }
        return this.entry;
    }

    protected URL getURL(VirtualFileHandler parent, String path, boolean isDirEntry) throws MalformedURLException {
        StringBuilder buffer = new StringBuilder();
        try {
            String parentUrl = parent.toURL().toString();
            if (parent instanceof JarEntryHandler || parent instanceof SynthenticDirEntryHandler) {
                buffer.append(parentUrl);
            } else {
                buffer.append("jar:").append(parentUrl).append("!/");
            }
            if (buffer.charAt(buffer.length() - 1) != '/') {
                buffer.append('/');
            }
            buffer.append(path);
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
        if (isDirEntry && buffer.charAt(buffer.length() - 1) != '/') {
            buffer.append('/');
        }
        return new URL(buffer.toString());
    }

    public boolean isLeaf() {
        this.checkClosed();
        return false;
    }

    public static JarFile fromURL(URL url) throws IOException {
        try {
            JarURLConnection jarConnection;
            URLConnection connection = url.openConnection();
            if (connection instanceof JarURLConnection) {
                jarConnection = (JarURLConnection)connection;
            } else {
                URL jarUrl = new URL("jar:" + url + "!/");
                jarConnection = (JarURLConnection)jarUrl.openConnection();
            }
            jarConnection.setUseCaches(false);
            return jarConnection.getJarFile();
        }
        catch (IOException original) {
            IOException e = new IOException("Error opening jar file: " + url + " reason=" + original.getMessage());
            e.setStackTrace(original.getStackTrace());
            throw e;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        URL jarURL = this.getURL();
        String jarAsString = jarURL.toString();
        if (jarAsString.startsWith("file:")) {
            File fp = new File(jarAsString.substring(5));
            this.jar = new JarFile(fp);
        } else {
            URLConnection conn = jarURL.openConnection();
            if (conn instanceof JarURLConnection) {
                JarURLConnection jconn = (JarURLConnection)conn;
                this.jar = jconn.getJarFile();
            } else {
                throw new IOException("Cannot restore from non-JarURLConnection, url: " + jarURL);
            }
        }
        this.handleJarFile();
    }

    protected void handleJarFile() throws IOException {
        Stack<AbstractJarHandler> handlers = new Stack<AbstractJarHandler>();
        AbstractJarHandler current = this;
        while (current.getParent() instanceof AbstractJarHandler) {
            handlers.push(current);
            current = (AbstractJarHandler)current.getParent();
        }
        while (!handlers.isEmpty()) {
            if (this.entry != null) {
                // empty if block
            }
            current = (AbstractJarHandler)handlers.pop();
            this.entry = this.jar.getEntry(current.getName());
        }
    }
}

