/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.virtual.plugins.context.jar.AbstractStructuredJarHandler;
import org.jboss.virtual.plugins.context.jar.JarEntryContents;
import org.jboss.virtual.plugins.context.jar.ZipEntryWrapper;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedJarFromStream
extends AbstractStructuredJarHandler<byte[]> {
    private static final long serialVersionUID = 2L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("zisBytes", byte[].class), new ObjectStreamField("jarURL", URL.class), new ObjectStreamField("entryURL", String.class), new ObjectStreamField("lastModified", Long.TYPE), new ObjectStreamField("size", Long.TYPE)};
    private transient ZipInputStream zis;
    private transient AtomicBoolean inited = new AtomicBoolean(false);
    private URL jarURL;
    private URL entryURL;
    private long lastModified;
    private long size;

    public NestedJarFromStream(VFSContext context, VirtualFileHandler parent, ZipInputStream zis, URL jarURL, JarFile jar, ZipEntry entry, String entryName) throws IOException {
        super(context, parent, jarURL, jar, entry, entryName);
        this.jarURL = jarURL;
        this.lastModified = entry.getTime();
        this.size = entry.getSize();
        this.zis = zis;
        try {
            this.setPathName(this.getChildPathName(entryName, false));
            this.setVfsUrl(this.getChildVfsUrl(entryName, false));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void initCacheLastModified() {
        this.cachedLastModified = this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws IOException {
        if (!this.inited.get()) {
            this.inited.set(true);
            try {
                this.initJarFile(new ZisEnumeration());
            }
            finally {
                this.close();
            }
        }
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        this.init();
        return super.getChildren(ignoreErrors);
    }

    @Override
    public VirtualFileHandler getChild(String path) throws IOException {
        this.init();
        return super.getChild(path);
    }

    @Override
    public VirtualFileHandler createChildHandler(String name) throws IOException {
        this.init();
        return super.createChildHandler(name);
    }

    @Override
    protected void extraWrapperInfo(ZipEntryWrapper<byte[]> wrapper) throws IOException {
        byte[] contents;
        int size = (int)wrapper.getSize();
        if (size != 0) {
            ByteArrayOutputStream baos = size > 0 ? new ByteArrayOutputStream(size) : new ByteArrayOutputStream();
            byte[] tmp = new byte[1024];
            while (this.zis.available() > 0) {
                int length = this.zis.read(tmp);
                if (length <= 0) continue;
                baos.write(tmp, 0, length);
            }
            contents = baos.toByteArray();
        } else {
            contents = new byte[]{};
        }
        wrapper.setExtra(contents);
    }

    @Override
    protected VirtualFileHandler createVirtualFileHandler(VirtualFileHandler parent, ZipEntryWrapper<byte[]> wrapper, String entryName) throws IOException {
        try {
            String url = this.toURI().toASCIIString() + "!/" + wrapper.getName();
            URL jecURL = new URL(url);
            VFSContext context = parent.getVFSContext();
            byte[] contents = wrapper.getExtra();
            return new JarEntryContents(context, parent, wrapper.getEntry(), entryName, this.toURL(), jecURL, contents);
        }
        catch (Throwable t) {
            IOException ioe = new IOException("Exception while reading nested jar entry: " + this);
            ioe.initCause(t);
            ioe.setStackTrace(t.getStackTrace());
            throw ioe;
        }
    }

    @Override
    public boolean exists() throws IOException {
        return true;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getLastModified() throws IOException {
        return this.lastModified;
    }

    @Override
    public InputStream openStream() throws IOException {
        if (this.zis == null) {
            InputStream parentIS = super.getParent().openStream();
            if (parentIS == null) {
                throw new IOException("Failed to open parent stream, " + this);
            }
            this.zis = parentIS instanceof ZipInputStream ? (ZipInputStream)parentIS : new ZipInputStream(parentIS);
            ZipEntry entry = this.zis.getNextEntry();
            while (entry != null && !entry.getName().equals(this.getName())) {
                entry = this.zis.getNextEntry();
            }
            if (entry == null) {
                throw new IOException("Failed to find nested jar entry: " + this.getName() + " in parent: " + this.getParent());
            }
        }
        return this.zis;
    }

    @Override
    public void close() {
        if (this.zis != null) {
            try {
                this.zis.close();
            }
            catch (IOException e) {
                log.error((Object)"close error", (Throwable)e);
            }
            this.zis = null;
        }
    }

    @Override
    public URI toURI() throws URISyntaxException {
        try {
            if (this.entryURL == null) {
                this.entryURL = new URL(this.jarURL, this.getName());
            }
        }
        catch (MalformedURLException e) {
            throw new URISyntaxException("Failed to create relative jarURL", e.getMessage());
        }
        return this.entryURL.toURI();
    }

    @Override
    public String toString() {
        StringBuffer tmp = new StringBuffer(super.toString());
        tmp.append('[');
        tmp.append("name=");
        tmp.append(this.getName());
        tmp.append(",size=");
        tmp.append(this.getSize());
        tmp.append(",lastModified=");
        tmp.append(this.lastModified);
        tmp.append(",URI=");
        try {
            tmp.append(this.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        tmp.append(']');
        return tmp.toString();
    }

    @Override
    protected void initJarFile() throws IOException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        ZipInputStream jarStream = this.zis;
        if (jarStream == null) {
            InputStream parentIS = super.getParent().openStream();
            if (parentIS == null) {
                throw new IOException("Failed to open parent stream, " + this);
            }
            jarStream = new ZipInputStream(parentIS);
            ZipEntry entry = jarStream.getNextEntry();
            while (entry != null && !entry.getName().equals(this.getName())) {
                entry = jarStream.getNextEntry();
            }
            if (entry == null) {
                throw new IOException("Failed to find nested jar entry: " + this.getName() + " in parent: " + this.getParent());
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] tmp = new byte[1024];
        int length = jarStream.read(tmp);
        while (length > 0) {
            baos.write(tmp, 0, length);
            length = jarStream.read(tmp);
        }
        jarStream.close();
        jarStream = null;
        byte[] zisBytes = baos.toByteArray();
        fields.put("zisBytes", zisBytes);
        fields.put("jarURL", this.jarURL);
        fields.put("entryURL", this.entryURL);
        fields.put("lastModified", this.lastModified);
        fields.put("size", this.size);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        byte[] zisBytes = (byte[])fields.get("zisBytes", null);
        this.jarURL = (URL)fields.get("jarURL", null);
        this.entryURL = (URL)fields.get("entryURL", null);
        this.lastModified = fields.get("lastModified", -1L);
        this.size = fields.get("size", -1L);
        this.inited = new AtomicBoolean(false);
        ByteArrayInputStream bais = new ByteArrayInputStream(zisBytes);
        this.zis = new ZipInputStream(bais);
        this.init();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ZisEnumeration
    implements Enumeration<ZipEntryWrapper<byte[]>> {
        private boolean moved = true;
        private ZipEntry next = null;

        private ZisEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            if (NestedJarFromStream.this.zis == null) {
                return false;
            }
            try {
                if (this.moved) {
                    this.next = NestedJarFromStream.this.zis.getNextEntry();
                    this.moved = false;
                }
                return this.next != null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public ZipEntryWrapper<byte[]> nextElement() {
            this.moved = true;
            return new ZipEntryWrapper<byte[]>(this.next);
        }
    }
}

