/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.memory;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.virtual.plugins.context.AbstractURLHandler;
import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryContextHandler
extends AbstractURLHandler
implements StructuredVirtualFileHandler {
    private static final long serialVersionUID = 1L;
    private Map<String, MemoryContextHandler> entryMap = Collections.emptyMap();
    private byte[] contents;

    public MemoryContextHandler(VFSContext context, VirtualFileHandler parent, URL url, String name) {
        super(context, parent, url, name);
        if (parent != null && parent instanceof MemoryContextHandler) {
            ((MemoryContextHandler)parent).addChild(name, this);
        }
    }

    protected synchronized void addChild(String name, MemoryContextHandler child) {
        if (this.entryMap == Collections.EMPTY_MAP) {
            this.entryMap = new LinkedHashMap<String, MemoryContextHandler>();
        }
        this.entryMap.put(name, child);
    }

    boolean deleteChild(MemoryContextHandler child) {
        return this.entryMap.remove(child.getName()) != null;
    }

    MemoryContextHandler getDirectChild(String name) {
        return this.entryMap.get(name);
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        return new ArrayList<VirtualFileHandler>(this.entryMap.values());
    }

    @Override
    public boolean isLeaf() {
        return this.contents != null;
    }

    @Override
    public VirtualFileHandler createChildHandler(String name) throws IOException {
        return this.entryMap.get(name);
    }

    @Override
    public VirtualFileHandler getChild(String path) throws IOException {
        return this.structuredFindChild(path);
    }

    @Override
    public boolean exists() throws IOException {
        return true;
    }

    byte[] getContents() {
        return this.contents;
    }

    public void setContents(byte[] contents) {
        if (this.entryMap.size() > 0) {
            throw new RuntimeException("Cannot set contents for non-leaf node");
        }
        this.initCacheLastModified();
        this.contents = contents;
    }

    @Override
    protected void initCacheLastModified() {
        this.cachedLastModified = System.currentTimeMillis();
    }

    @Override
    public long getSize() throws IOException {
        if (this.contents != null) {
            return this.contents.length;
        }
        return 0L;
    }

    @Override
    public long getLastModified() throws IOException {
        return this.cachedLastModified;
    }

    @Override
    public InputStream openStream() throws IOException {
        if (this.contents != null) {
            return new ByteArrayInputStream(this.contents);
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public URL toVfsUrl() throws MalformedURLException, URISyntaxException {
        if (this.getVfsUrl() == null) {
            if (this.isLeaf()) {
                this.setVfsUrl(this.getURL());
            } else {
                String vfsString = this.getURL().toString();
                if (!vfsString.endsWith("/")) {
                    this.setVfsUrl(new URL(vfsString + "/"));
                }
            }
        }
        return this.getVfsUrl();
    }
}

