/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.vfs.helpers;

import java.io.IOException;
import java.util.StringTokenizer;

public class PathTokenizer {
    private static final String CURRENT_PATH = ".";
    private static final String REVERSE_PATH = "..";

    private PathTokenizer() {
    }

    protected static String getRemainingPath(String[] tokens, int i, int end) {
        if (tokens == null) {
            throw new IllegalArgumentException("Null tokens");
        }
        if (i < 0 || i >= end) {
            throw new IllegalArgumentException("i is not in the range of tokens: 0-" + (end - 1));
        }
        if (i == end - 1) {
            return tokens[end - 1];
        }
        StringBuilder buffer = new StringBuilder();
        while (i < end - 1) {
            buffer.append(tokens[i]);
            buffer.append("/");
            ++i;
        }
        buffer.append(tokens[end - 1]);
        return buffer.toString();
    }

    public static String[] getTokens(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        int count = tokenizer.countTokens();
        if (count == 0) {
            return null;
        }
        String[] tokens = new String[count];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ("".equals(token)) {
                throw new IllegalArgumentException("A path element is empty: " + path);
            }
            tokens[i++] = token;
        }
        return tokens;
    }

    public static String getRemainingPath(String[] tokens, int i) {
        if (tokens == null) {
            throw new IllegalArgumentException("Null tokens");
        }
        return PathTokenizer.getRemainingPath(tokens, i, tokens.length);
    }

    public static String applySpecialPaths(String path) throws IOException {
        String[] tokens = PathTokenizer.getTokens(path);
        if (tokens == null) {
            return null;
        }
        int i = 0;
        for (int j = 0; j < tokens.length; ++j) {
            String token = tokens[j];
            if (PathTokenizer.isCurrentToken(token)) continue;
            if (PathTokenizer.isReverseToken(token)) {
                --i;
            } else {
                tokens[i++] = token;
            }
            if (i >= 0) continue;
            throw new IOException("Using reverse path on top path: " + path);
        }
        return PathTokenizer.getRemainingPath(tokens, 0, i);
    }

    public static boolean isCurrentToken(String token) {
        return CURRENT_PATH.equals(token);
    }

    public static boolean isReverseToken(String token) {
        return REVERSE_PATH.equals(token);
    }
}

