/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.logging.Logger;
import org.jboss.virtual.plugins.context.zip.ZipEntryInputStream;
import org.jboss.virtual.plugins.context.zip.ZipFileLockReaper;
import org.jboss.virtual.plugins.context.zip.ZipWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ZipFileWrapper
extends ZipWrapper {
    private static final Logger log = Logger.getLogger(ZipFileWrapper.class);
    private static boolean forceNoReaper = AccessController.doPrivileged(new CheckNoReaper());
    private File file;
    private ZipFile zipFile;
    private boolean autoClean;
    private boolean noReaperOverride;

    ZipFileWrapper(File archive, boolean autoClean, boolean noReaperOverride) {
        this.noReaperOverride = noReaperOverride;
        this.init(archive, autoClean);
    }

    ZipFileWrapper(URI rootPathURI, boolean autoClean, boolean noReaperOverride) {
        this.noReaperOverride = noReaperOverride;
        File rootFile = new File(rootPathURI);
        if (!rootFile.isFile()) {
            throw new RuntimeException("File not found: " + rootFile);
        }
        this.init(rootFile, autoClean);
    }

    private void init(File archive, boolean autoClean) {
        this.file = archive;
        this.lastModified = this.file.lastModified();
        this.autoClean = autoClean;
        if (autoClean) {
            this.file.deleteOnExit();
        }
    }

    @Override
    boolean exists() {
        return this.file.isFile();
    }

    @Override
    long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    String getName() {
        return this.file.getName();
    }

    @Override
    long getSize() {
        return this.file.length();
    }

    private ZipFile ensureZipFile() throws IOException {
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(this.file);
            if (!forceNoReaper && !this.noReaperOverride) {
                ZipFileLockReaper.getInstance().register(this);
            }
        }
        return this.zipFile;
    }

    synchronized void closeZipFile() throws IOException {
        if (this.zipFile != null && this.getReferenceCount() <= 0) {
            ZipFile zf = this.zipFile;
            this.zipFile = null;
            zf.close();
            if (!forceNoReaper && !this.noReaperOverride) {
                ZipFileLockReaper.getInstance().unregister(this);
            }
        }
    }

    @Override
    synchronized InputStream openStream(ZipEntry ent) throws IOException {
        this.ensureZipFile();
        InputStream is = this.zipFile.getInputStream(ent);
        if (is == null) {
            throw new IOException("Entry no longer available: " + ent.getName() + " in file " + this.file);
        }
        ZipEntryInputStream zis = new ZipEntryInputStream(this, is);
        this.incrementRef();
        return zis;
    }

    @Override
    InputStream getRootAsStream() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    @Override
    synchronized void acquire() throws IOException {
        this.ensureZipFile();
        this.incrementRef();
    }

    @Override
    synchronized void release() {
        super.release();
        if (forceNoReaper || this.noReaperOverride) {
            try {
                this.closeZipFile();
            }
            catch (Exception ex) {
                log.warn((Object)("Failed to release file: " + this.file));
            }
        }
    }

    @Override
    synchronized Enumeration<? extends ZipEntry> entries() throws IOException {
        return this.ensureZipFile().entries();
    }

    @Override
    void close() {
        try {
            this.closeZipFile();
        }
        catch (Exception ignored) {
            log.warn((Object)("IGNORING: Failed to release file: " + this.file), (Throwable)ignored);
        }
        if (this.autoClean) {
            this.file.delete();
        }
    }

    public String toString() {
        return super.toString() + " - " + this.file.getAbsolutePath();
    }

    static {
        if (forceNoReaper) {
            log.info((Object)"VFS forced no-reaper-mode is enabled.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckNoReaper
    implements PrivilegedAction<Boolean> {
        private CheckNoReaper() {
        }

        @Override
        public Boolean run() {
            String forceString = System.getProperty("jboss.vfs.forceNoReaper", "false");
            return Boolean.valueOf(forceString);
        }
    }
}

