/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.cluster.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.lock.LocalAndClusterLockManager;
import org.jboss.ha.framework.server.lock.TimeoutException;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.logging.Logger;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.system.server.profileservice.repository.clustered.RepositoryClusteringHandler;
import org.jboss.system.server.profileservice.repository.clustered.local.LocalContentManager;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryContentMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryItemMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryRootMetadata;
import org.jboss.system.server.profileservice.repository.clustered.sync.ByteChunk;
import org.jboss.system.server.profileservice.repository.clustered.sync.ContentModification;
import org.jboss.system.server.profileservice.repository.clustered.sync.ImmutableSynchronizationPolicy;
import org.jboss.system.server.profileservice.repository.clustered.sync.InconsistentRepositoryStructureException;
import org.jboss.system.server.profileservice.repository.clustered.sync.LocalContentModificationGenerator;
import org.jboss.system.server.profileservice.repository.clustered.sync.RemoteContentModificationGenerator;
import org.jboss.system.server.profileservice.repository.clustered.sync.SynchronizationAction;
import org.jboss.system.server.profileservice.repository.clustered.sync.SynchronizationId;
import org.jboss.system.server.profileservice.repository.clustered.sync.SynchronizationInitiationAction;
import org.jboss.system.server.profileservice.repository.clustered.sync.SynchronizationPolicy;
import org.jboss.system.server.profileservice.repository.clustered.sync.SynchronizationReadAction;
import org.jboss.system.server.profileservice.repository.clustered.sync.SynchronizationRemoteAction;
import org.jboss.system.server.profileservice.repository.clustered.sync.SynchronizationWriteAction;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositoryClusteringHandler
implements RepositoryClusteringHandler,
KernelControllerContextAware {
    private static final Logger log = Logger.getLogger(DefaultRepositoryClusteringHandler.class);
    private static final Class<?>[] JOIN_SYNCHRONIZE_TYPES = new Class[]{RepositoryContentMetadata.class, RepositoryContentMetadata.class};
    private static final Class<?>[] MERGE_SYNCHRONIZE_TYPES = new Class[]{RepositoryContentMetadata.class};
    private static final Class<?>[] INITIATE_SYNCHRONIZATION_TYPES = new Class[]{SynchronizationId.class, List.class};
    private static final Class<?>[] TX_TYPES = new Class[]{SynchronizationId.class};
    private static final Class<?>[] EXECUTE_MOD_TYPES = new Class[]{SynchronizationId.class, RepositoryItemMetadata.class, Boolean.TYPE};
    private static final Class<?>[] PULL_BYTES_TYPES = new Class[]{SynchronizationId.class, RepositoryItemMetadata.class};
    private static final Class<?>[] PUSH_BYTES_TYPES = new Class[]{SynchronizationId.class, RepositoryItemMetadata.class, ByteChunk.class};
    public static final long DEFAULT_TIMEOUT = 60000L;
    private String serviceHAName;
    private HAPartition partition;
    private String profileDomain;
    private String profileServer;
    private String profileName;
    private boolean immutable;
    private LocalAndClusterLockManager lockSupport;
    private SynchronizationPolicy synchronizationPolicy;
    private LocalContentManager<?> contentManager;
    private RpcTarget rpcTarget = new RpcTarget();
    private boolean inSync = false;
    private long lockTimeout = 60000L;
    private long methodCallTimeout = 60000L;
    private volatile ActiveSynchronization activeSynchronization;
    private final DRMListener drmListener = new DRMListener();
    private List<ClusterNode> serviceView;
    private boolean initialized;

    public HAPartition getPartition() {
        return this.partition;
    }

    public void setPartition(HAPartition partition) {
        this.checkUnitialized();
        this.partition = partition;
    }

    public String getProfileDomain() {
        return this.profileDomain;
    }

    public void setProfileDomain(String profileDomain) {
        this.checkUnitialized();
        this.profileDomain = profileDomain;
    }

    public String getProfileServer() {
        return this.profileServer;
    }

    public void setProfileServer(String profileServer) {
        this.checkUnitialized();
        this.profileServer = profileServer;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.checkUnitialized();
        this.profileName = profileName;
    }

    public String getServiceHAName() {
        return this.serviceHAName;
    }

    public void setServiceHAName(String serviceHAName) {
        this.checkUnitialized();
        this.serviceHAName = serviceHAName;
    }

    public SynchronizationPolicy getSynchronizationPolicy() {
        return this.synchronizationPolicy;
    }

    public void setSynchronizationPolicy(SynchronizationPolicy synchronizationPolicy) {
        this.checkUnitialized();
        if (!this.immutable) {
            this.synchronizationPolicy = synchronizationPolicy;
        }
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutable(boolean immutable) {
        this.checkUnitialized();
        if (immutable && !this.immutable) {
            this.setSynchronizationPolicy((SynchronizationPolicy)new ImmutableSynchronizationPolicy());
        }
        this.immutable = immutable;
    }

    public long getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(long lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    public long getMethodCallTimeout() {
        return this.methodCallTimeout;
    }

    public void setMethodCallTimeout(long methodCallTimeout) {
        this.methodCallTimeout = methodCallTimeout;
    }

    public void initialize(LocalContentManager<?> persister) throws Exception {
        if (persister == null) {
            throw new IllegalArgumentException("Null persister");
        }
        if (this.partition == null) {
            throw new IllegalStateException("Null partition; must inject an HAPartition before invoking initialize");
        }
        if (this.serviceHAName == null) {
            throw new IllegalStateException("Null serviceHAName; must inject a serviceHAName before invoking initialize");
        }
        if (this.synchronizationPolicy == null) {
            throw new IllegalStateException("Null synchronizationPolicy; must inject a RepositorySynchronizationPolicy before invoking initialize");
        }
        this.contentManager = persister;
        String lockServiceName = this.serviceHAName + "-ClusterLock";
        this.lockSupport = new LocalAndClusterLockManager(lockServiceName, this.partition);
        this.lockSupport.start();
        this.partition.registerRPCHandler(this.getServiceHAName(), (Object)this.rpcTarget);
        DistributedReplicantManager drm = this.partition.getDistributedReplicantManager();
        drm.add(this.getServiceHAName(), (Serializable)this.partition.getClusterNode());
        this.serviceView = drm.lookupReplicantsNodes(this.getServiceHAName());
        drm.registerListener(this.getServiceHAName(), (DistributedReplicantManager.ReplicantListener)this.drmListener);
        this.initialized = true;
    }

    public void shutdown() throws Exception {
        DistributedReplicantManager drm = this.partition.getDistributedReplicantManager();
        drm.unregisterListener(this.getServiceHAName(), (DistributedReplicantManager.ReplicantListener)this.drmListener);
        drm.remove(this.getServiceHAName());
        this.partition.unregisterRPCHandler(this.getServiceHAName(), (Object)this.rpcTarget);
        this.lockSupport.stop();
        this.contentManager = null;
        this.initialized = false;
    }

    public String getPartitionName() {
        return this.partition == null ? null : this.partition.getPartitionName();
    }

    public String getLocalNodeName() {
        ClusterNode localNode = this.partition == null ? null : this.partition.getClusterNode();
        return localNode == null ? null : localNode.getName();
    }

    public ProfileKey getProfileKey() {
        return new ProfileKey(this.profileDomain, this.profileServer, this.profileName);
    }

    public RepositoryContentMetadata synchronizeContent(boolean pullFromCluster) throws InconsistentRepositoryStructureException, IOException {
        List<ContentModification> modifications = null;
        RepositoryContentMetadata localCurrentContent = this.contentManager.getCurrentContentMetadata();
        modifications = pullFromCluster ? this.getModificationsFromCluster(localCurrentContent) : (!this.inSync ? this.getModificationsFromCluster(null) : this.getLocalModifications(localCurrentContent));
        if (modifications != null) {
            this.installModifications(modifications, localCurrentContent);
        } else {
            this.contentManager.installCurrentContentMetadata();
        }
        RepositoryContentMetadata result = this.contentManager.getOfficialContentMetadata();
        this.inSync = true;
        return result;
    }

    public RepositoryItemMetadata addDeploymentContent(String vfsPath, InputStream contentIS) throws IOException {
        List modifications;
        RepositoryItemMetadata item = this.contentManager.getItemForAddition(vfsPath);
        RepositoryContentMetadata updated = this.contentManager.getContentMetadataForAdd(item, contentIS);
        RepositoryContentMetadata official = this.contentManager.getOfficialContentMetadata();
        LocalContentModificationGenerator generator = new LocalContentModificationGenerator();
        try {
            modifications = generator.getModificationList(official, updated);
        }
        catch (InconsistentRepositoryStructureException e) {
            throw new IllegalStateException("Incompatible structure change", e);
        }
        this.installModifications(modifications, updated);
        official = this.contentManager.getOfficialContentMetadata();
        RepositoryRootMetadata rrmd = official.getRepositoryRootMetadata(item.getRootName());
        return rrmd.getItemMetadata(item.getRelativePathElements());
    }

    public void removeDeploymentContent(VirtualFile vf) throws Exception {
        List modifications;
        RepositoryContentMetadata updated = this.contentManager.getContentMetadataForRemove(vf);
        RepositoryContentMetadata official = this.contentManager.getOfficialContentMetadata();
        LocalContentModificationGenerator generator = new LocalContentModificationGenerator();
        try {
            modifications = generator.getModificationList(official, updated);
        }
        catch (InconsistentRepositoryStructureException e) {
            throw new IllegalStateException("Incompatible structure change", e);
        }
        this.installModifications(modifications, updated);
    }

    public boolean lockGlobally() {
        try {
            this.lockSupport.lockGlobally((Serializable)((Object)this.getServiceHAName()), this.lockTimeout);
            return true;
        }
        catch (TimeoutException e) {
            log.info((Object)("Unable to acquire global lock: " + e.getLocalizedMessage()));
        }
        catch (InterruptedException e) {
            log.info((Object)("Interrupted while obtaining global lock: " + e.getLocalizedMessage()));
            Thread.currentThread().interrupt();
        }
        return false;
    }

    public boolean lockLocally() {
        try {
            this.lockSupport.lockLocally((Serializable)((Object)this.getServiceHAName()), this.lockTimeout);
            return true;
        }
        catch (TimeoutException e) {
            log.info((Object)("Unable to acquire local lock: " + e.getLocalizedMessage()));
        }
        catch (InterruptedException e) {
            log.info((Object)("Interrupted while obtaining global lock: " + e.getLocalizedMessage()));
            Thread.currentThread().interrupt();
        }
        return false;
    }

    public void unlockGlobally() {
        this.lockSupport.unlockGlobally((Serializable)((Object)this.getServiceHAName()));
    }

    public void unlockLocally() {
        this.lockSupport.unlockLocally((Serializable)((Object)this.getServiceHAName()));
    }

    public void setKernelControllerContext(KernelControllerContext context) throws Exception {
        if (context != null && this.serviceHAName == null) {
            this.setServiceHAName(context.getName().toString());
        }
    }

    public void unsetKernelControllerContext(KernelControllerContext context) throws Exception {
    }

    protected RpcTarget getRpcTarget() {
        return this.rpcTarget;
    }

    protected DRMListener getDRMListener() {
        return this.drmListener;
    }

    private List<ContentModification> getModificationsFromCluster(RepositoryContentMetadata localCurrentContent) throws IOException, InconsistentRepositoryStructureException {
        List modifications = null;
        RepositoryContentMetadata localBaseMetadata = this.contentManager.getOfficialContentMetadata();
        if (localBaseMetadata == null) {
            localBaseMetadata = this.contentManager.createEmptyContentMetadata();
        }
        List nodes = this.partition.getDistributedReplicantManager().lookupReplicantsNodes(this.getServiceHAName());
        for (ClusterNode node : nodes) {
            if (node.equals(this.partition.getClusterNode())) continue;
            try {
                Object[] args;
                Object rsp = null;
                String methodName = null;
                if (localCurrentContent != null) {
                    methodName = "joinSynchronizeContent";
                    args = new Object[]{localBaseMetadata, localCurrentContent};
                    rsp = this.partition.callMethodOnNode(this.getServiceHAName(), methodName, args, (Class[])JOIN_SYNCHRONIZE_TYPES, this.methodCallTimeout, node);
                } else {
                    methodName = "mergeSynchronizeContent";
                    args = new Object[]{localBaseMetadata};
                    rsp = this.partition.callMethodOnNode(this.getServiceHAName(), methodName, args, (Class[])MERGE_SYNCHRONIZE_TYPES, this.methodCallTimeout, node);
                }
                if (rsp instanceof NotSynchronizedException) {
                    throw (NotSynchronizedException)rsp;
                }
                if (rsp instanceof List) {
                    List mods;
                    modifications = mods = (List)rsp;
                    break;
                }
                log.warn((Object)("Unknown response to " + methodName + ": " + rsp));
            }
            catch (NotSynchronizedException ignored) {
                log.debug((Object)("Cannot synchronize with " + node + " as it itself is not yet synchronized"));
            }
            catch (InconsistentRepositoryStructureException e) {
                throw e;
            }
            catch (Throwable t) {
                DefaultRepositoryClusteringHandler.rethrowAsUnchecked(t);
            }
        }
        return modifications;
    }

    private List<ContentModification> getLocalModifications(RepositoryContentMetadata localCurrentContent) {
        RepositoryContentMetadata official = this.contentManager.getOfficialContentMetadata();
        LocalContentModificationGenerator generator = new LocalContentModificationGenerator();
        try {
            return generator.getModificationList(official, localCurrentContent);
        }
        catch (InconsistentRepositoryStructureException e) {
            throw new IllegalStateException("Incompatible structure change", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void installModifications(List<ContentModification> modifications, RepositoryContentMetadata toInstall) {
        SynchronizationId id = new SynchronizationId((Serializable)this.partition.getClusterNode());
        boolean committed = false;
        Object[] args = new Object[]{id, modifications};
        ArrayList rsps = this.partition.callMethodOnCluster(this.getServiceHAName(), "initiateSynchronization", args, (Class[])INITIATE_SYNCHRONIZATION_TYPES, true);
        for (Object rsp : rsps) {
            if (rsp instanceof NotSynchronizedException || !(rsp instanceof Exception)) continue;
            throw (Exception)rsp;
        }
        this.handleInitiateSynchronization((SynchronizationId<ClusterNode>)id, modifications, toInstall);
        this.executeSynchronizationActions();
        rsps = this.partition.callMethodOnCluster(this.getServiceHAName(), "prepare", new Object[]{id}, (Class[])TX_TYPES, true);
        boolean prepareOK = true;
        for (Object rsp : rsps) {
            if (rsp instanceof NotSynchronizedException) continue;
            if (rsp instanceof Exception) {
                throw (Exception)rsp;
            }
            if (Boolean.TRUE.equals(rsp)) continue;
            prepareOK = false;
            break;
        }
        if (prepareOK && this.handlePrepare((SynchronizationId<ClusterNode>)id)) {
            this.partition.callMethodOnCluster(this.getServiceHAName(), "commit", new Object[]{id}, (Class[])TX_TYPES, true);
            this.handleCommit((SynchronizationId<ClusterNode>)id);
            return;
        }
        if (committed) return;
        try {
            this.partition.callMethodOnCluster(this.getServiceHAName(), "rollback", new Object[]{id}, (Class[])TX_TYPES, true);
            return;
        }
        catch (Exception e) {
            log.error((Object)("Failed to roll back synchronization " + id + " on remote nodes"), (Throwable)e);
            return;
        }
        finally {
            this.handleRollback((SynchronizationId<ClusterNode>)id);
        }
        catch (Exception e) {
            try {
                DefaultRepositoryClusteringHandler.rethrowAsUnchecked(e);
                if (committed) return;
            }
            catch (Throwable throwable) {
                if (committed) throw throwable;
                try {
                    this.partition.callMethodOnCluster(this.getServiceHAName(), "rollback", new Object[]{id}, (Class[])TX_TYPES, true);
                    throw throwable;
                }
                catch (Exception e2) {
                    log.error((Object)("Failed to roll back synchronization " + id + " on remote nodes"), (Throwable)e2);
                    throw throwable;
                }
                finally {
                    this.handleRollback((SynchronizationId<ClusterNode>)id);
                }
            }
            try {
                this.partition.callMethodOnCluster(this.getServiceHAName(), "rollback", new Object[]{id}, (Class[])TX_TYPES, true);
                return;
            }
            catch (Exception e3) {
                log.error((Object)("Failed to roll back synchronization " + id + " on remote nodes"), (Throwable)e3);
                return;
            }
            finally {
                this.handleRollback((SynchronizationId<ClusterNode>)id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSynchronizationActions() throws Exception {
        ActiveSynchronization active = this.activeSynchronization;
        if (active == null) {
            throw new IllegalStateException("No active synchronization");
        }
        SynchronizationId<ClusterNode> id = active.getId();
        ActiveSynchronization activeSynchronization = active;
        synchronized (activeSynchronization) {
            for (SynchronizationAction<?> action : active.getActions()) {
                if (!active.isAlive()) {
                    throw new RuntimeException("Synchronization " + id + " terminated");
                }
                if (action instanceof SynchronizationReadAction) {
                    this.executePush(id, (SynchronizationReadAction)action);
                    continue;
                }
                if (action instanceof SynchronizationWriteAction) {
                    this.executePull(id, (SynchronizationWriteAction)action);
                    continue;
                }
                if (action instanceof SynchronizationRemoteAction) {
                    this.executeRemoteAction(id, (SynchronizationRemoteAction)action);
                    continue;
                }
                action.complete();
            }
        }
    }

    private void executePull(SynchronizationId<?> id, SynchronizationWriteAction<?> action) throws Exception {
        List peers = this.partition.getDistributedReplicantManager().lookupReplicantsNodes(this.getServiceHAName());
        peers.remove(this.partition.getClusterNode());
        boolean ok = false;
        Exception lastCaught = null;
        for (ClusterNode peer : peers) {
            try {
                if (this.executePullFromPeer(id, action, peer)) {
                    ok = true;
                    break;
                }
            }
            catch (Exception e) {
                lastCaught = e;
            }
            action.cancel();
        }
        if (!ok) {
            if (lastCaught != null) {
                throw lastCaught;
            }
            throw new RuntimeException("No node able to provide item " + action.getRepositoryContentModification().getItem());
        }
        action.complete();
    }

    private boolean executePullFromPeer(SynchronizationId<?> id, SynchronizationWriteAction<?> action, ClusterNode node) throws Exception {
        int lastRead = 0;
        while (lastRead > -1) {
            Object[] args = new Object[]{id, action.getRepositoryContentModification().getItem()};
            Object rsp = null;
            try {
                rsp = this.partition.callMethodOnNode(this.getServiceHAName(), "pullBytes", args, (Class[])PULL_BYTES_TYPES, this.methodCallTimeout, node);
            }
            catch (Throwable t) {
                DefaultRepositoryClusteringHandler.rethrowAsException(t);
            }
            if (rsp instanceof ByteChunk) {
                ByteChunk chunk = (ByteChunk)rsp;
                lastRead = chunk.getByteCount();
                if (lastRead <= -1) continue;
                action.writeBytes(chunk);
                continue;
            }
            if (rsp instanceof NotSynchronizedException) {
                return false;
            }
            if (rsp instanceof Throwable) {
                DefaultRepositoryClusteringHandler.rethrowAsException((Throwable)rsp);
                continue;
            }
            if (rsp == null) {
                return false;
            }
            throw new IllegalStateException("Unknown response " + rsp);
        }
        return true;
    }

    private void executePush(SynchronizationId<?> id, SynchronizationReadAction<?> action) throws Exception {
        int lastRead = 0;
        while (lastRead > -1) {
            try {
                ByteChunk chunk = action.getNextBytes();
                Object[] args = new Object[]{id, action.getRepositoryContentModification().getItem(), chunk};
                this.partition.callAsynchMethodOnCluster(this.getServiceHAName(), "pushBytes", args, (Class[])PUSH_BYTES_TYPES, true);
                lastRead = chunk.getByteCount();
            }
            catch (Exception e) {
                action.cancel();
                throw e;
            }
        }
        action.complete();
    }

    private void executeRemoteAction(SynchronizationId<?> id, SynchronizationRemoteAction<?> action) throws Exception {
        Object[] args = new Object[]{id, action.getRepositoryContentModification().getItem(), action.isInitiation()};
        ArrayList rsps = null;
        try {
            rsps = this.partition.callMethodOnCluster(this.getServiceHAName(), "executeModification", args, (Class[])EXECUTE_MOD_TYPES, true);
        }
        catch (Exception e) {
            action.cancel();
            throw e;
        }
        action.complete();
        for (Object rsp : rsps) {
            if (rsp instanceof NotSynchronizedException || !(rsp instanceof Throwable)) continue;
            DefaultRepositoryClusteringHandler.rethrowAsException((Throwable)rsp);
        }
    }

    private void checkUnitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Cannot reconfigure an initialized " + this.getClass().getSimpleName());
        }
    }

    private void handleInitiateSynchronization(SynchronizationId<ClusterNode> id, List<ContentModification> modifications, RepositoryContentMetadata toInstall) {
        boolean localLed = ((ClusterNode)id.getOriginator()).equals(this.partition.getClusterNode());
        List actions = this.contentManager.initiateSynchronization(id, modifications, toInstall, localLed);
        this.activeSynchronization = new ActiveSynchronization(id, actions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handlePrepare(SynchronizationId<ClusterNode> id) throws NotSynchronizedException {
        ActiveSynchronization active = this.activeSynchronization;
        if (active != null) {
            ActiveSynchronization activeSynchronization = active;
            synchronized (activeSynchronization) {
                active.validate(id);
                return active.prepare();
            }
        }
        throw new NotSynchronizedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCommit(SynchronizationId<ClusterNode> id) {
        ActiveSynchronization active = this.activeSynchronization;
        if (active != null) {
            ActiveSynchronization activeSynchronization = active;
            synchronized (activeSynchronization) {
                active.validate(id);
                try {
                    active.commit();
                }
                finally {
                    this.activeSynchronization = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRollback(SynchronizationId<ClusterNode> id) {
        ActiveSynchronization active = this.activeSynchronization;
        if (active != null) {
            ActiveSynchronization activeSynchronization = active;
            synchronized (activeSynchronization) {
                active.validate(id);
                try {
                    active.rollback();
                }
                finally {
                    this.activeSynchronization = null;
                }
            }
        }
    }

    private static void rethrowAsException(Throwable t) throws Exception {
        if (t == null) {
            return;
        }
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    private static void rethrowAsUnchecked(Throwable t) {
        if (t == null) {
            return;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActiveSynchronization {
        private final SynchronizationId<ClusterNode> id;
        private final List<? extends SynchronizationAction<?>> localActions;
        private final Map<RepositoryItemMetadata, SynchronizationAction<?>> miscActionsByItem = new HashMap();
        private final Map<RepositoryItemMetadata, SynchronizationReadAction<?>> readActionsByItem = new HashMap();
        private final Map<RepositoryItemMetadata, SynchronizationWriteAction<?>> writeActionsByItem = new HashMap();
        private final Map<RepositoryItemMetadata, SynchronizationInitiationAction<?>> initiationActionsByItem = new HashMap();
        private volatile boolean alive = true;

        private ActiveSynchronization(SynchronizationId<ClusterNode> id, List<? extends SynchronizationAction<?>> localActions) {
            if (id == null) {
                throw new IllegalArgumentException("Null id");
            }
            if (localActions == null) {
                throw new IllegalArgumentException("Null localActions");
            }
            this.id = id;
            this.localActions = localActions;
            for (SynchronizationAction<?> action : localActions) {
                RepositoryItemMetadata item = action.getRepositoryContentModification().getItem();
                if (action instanceof SynchronizationInitiationAction) {
                    this.initiationActionsByItem.put(item, (SynchronizationInitiationAction)action);
                    continue;
                }
                if (action instanceof SynchronizationReadAction) {
                    this.readActionsByItem.put(item, (SynchronizationReadAction)action);
                    continue;
                }
                if (action instanceof SynchronizationWriteAction) {
                    this.writeActionsByItem.put(item, (SynchronizationWriteAction)action);
                    continue;
                }
                this.miscActionsByItem.put(item, action);
            }
        }

        public SynchronizationId<ClusterNode> getId() {
            return this.id;
        }

        public List<? extends SynchronizationAction<?>> getActions() {
            return this.localActions;
        }

        public void validate(SynchronizationId<ClusterNode> id) {
            if (!this.id.equals(id)) {
                throw new IllegalStateException("Invalid id " + id + " another synchronization " + this.getId() + " is in progress");
            }
        }

        public SynchronizationReadAction<?> getReadAction(RepositoryItemMetadata item) {
            return this.readActionsByItem.get(item);
        }

        public SynchronizationWriteAction<?> getWriteAction(RepositoryItemMetadata item) {
            return this.writeActionsByItem.get(item);
        }

        public SynchronizationInitiationAction<?> getInitiationAction(RepositoryItemMetadata item) {
            return this.initiationActionsByItem.get(item);
        }

        public SynchronizationAction<?> getMiscAction(RepositoryItemMetadata item) {
            return this.miscActionsByItem.get(item);
        }

        public boolean isAlive() {
            return this.alive;
        }

        public boolean prepare() {
            if (this.alive) {
                return DefaultRepositoryClusteringHandler.this.contentManager.prepareSynchronization(this.id);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback() {
            if (this.alive) {
                this.alive = false;
                ActiveSynchronization activeSynchronization = this;
                synchronized (activeSynchronization) {
                    DefaultRepositoryClusteringHandler.this.contentManager.rollbackSynchronization(this.id);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() {
            if (this.alive) {
                ActiveSynchronization activeSynchronization = this;
                synchronized (activeSynchronization) {
                    DefaultRepositoryClusteringHandler.this.contentManager.commitSynchronization(this.id);
                }
                this.alive = false;
            }
        }
    }

    private static class NotSynchronizedException
    extends Exception {
        private static final long serialVersionUID = -923676063561479453L;

        private NotSynchronizedException() {
        }
    }

    public class DRMListener
    implements DistributedReplicantManager.ReplicantListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void replicantsChanged(String key, List newReplicants, int newReplicantsViewId, boolean merge) {
            List oldView = DefaultRepositoryClusteringHandler.this.serviceView;
            DefaultRepositoryClusteringHandler.this.serviceView = newReplicants;
            ActiveSynchronization active = DefaultRepositoryClusteringHandler.this.activeSynchronization;
            if (active != null) {
                ActiveSynchronization activeSynchronization = active;
                synchronized (activeSynchronization) {
                    if (!DefaultRepositoryClusteringHandler.this.serviceView.contains(active.getId().getOriginator())) {
                        DefaultRepositoryClusteringHandler.this.contentManager.rollbackSynchronization(active.getId());
                        DefaultRepositoryClusteringHandler.this.activeSynchronization = null;
                    }
                }
            }
            if (merge) {
                ClusterNode master = newReplicants.size() > 0 ? newReplicants.get(0) : null;
                DefaultRepositoryClusteringHandler.this.inSync = master != null && oldView.contains(master);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RpcTarget {
        public List<ContentModification> joinSynchronizeContent(RepositoryContentMetadata remoteBaseContent, RepositoryContentMetadata remoteCurrentContent) throws NotSynchronizedException, InconsistentRepositoryStructureException {
            if (!DefaultRepositoryClusteringHandler.this.inSync) {
                throw new NotSynchronizedException();
            }
            RemoteContentModificationGenerator generator = new RemoteContentModificationGenerator(DefaultRepositoryClusteringHandler.this.synchronizationPolicy, remoteBaseContent);
            return generator.getModificationList(DefaultRepositoryClusteringHandler.this.contentManager.getOfficialContentMetadata(), remoteCurrentContent);
        }

        public List<ContentModification> mergeSynchronizeContent(RepositoryContentMetadata remoteCurrentContent) throws NotSynchronizedException, InconsistentRepositoryStructureException {
            if (!DefaultRepositoryClusteringHandler.this.inSync) {
                throw new NotSynchronizedException();
            }
            RemoteContentModificationGenerator generator = new RemoteContentModificationGenerator(DefaultRepositoryClusteringHandler.this.synchronizationPolicy);
            return generator.getModificationList(DefaultRepositoryClusteringHandler.this.contentManager.getOfficialContentMetadata(), remoteCurrentContent);
        }

        public void initiateSynchronization(SynchronizationId<ClusterNode> id, List<ContentModification> modifications) throws NotSynchronizedException {
            if (!DefaultRepositoryClusteringHandler.this.inSync) {
                throw new NotSynchronizedException();
            }
            RepositoryContentMetadata toInstall = new RepositoryContentMetadata(DefaultRepositoryClusteringHandler.this.contentManager.getOfficialContentMetadata());
            DefaultRepositoryClusteringHandler.this.handleInitiateSynchronization((SynchronizationId<ClusterNode>)id, modifications, toInstall);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeModification(SynchronizationId<ClusterNode> id, RepositoryItemMetadata item, boolean initiation) throws NotSynchronizedException {
            if (!DefaultRepositoryClusteringHandler.this.inSync) {
                throw new NotSynchronizedException();
            }
            ActiveSynchronization active = DefaultRepositoryClusteringHandler.this.activeSynchronization;
            if (active != null) {
                ActiveSynchronization activeSynchronization = active;
                synchronized (activeSynchronization) {
                    SynchronizationInitiationAction<?> action;
                    active.validate(id);
                    Object object = action = initiation ? active.getInitiationAction(item) : active.getMiscAction(item);
                    if (action == null) {
                        throw new IllegalStateException("No action for " + item);
                    }
                    action.complete();
                }
            } else {
                throw new NotSynchronizedException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pushBytes(SynchronizationId<ClusterNode> id, RepositoryItemMetadata item, ByteChunk chunk) throws NotSynchronizedException, IOException {
            if (!DefaultRepositoryClusteringHandler.this.inSync) {
                throw new NotSynchronizedException();
            }
            ActiveSynchronization active = DefaultRepositoryClusteringHandler.this.activeSynchronization;
            if (active != null) {
                ActiveSynchronization activeSynchronization = active;
                synchronized (activeSynchronization) {
                    active.validate(id);
                    SynchronizationWriteAction<?> action = active.getWriteAction(item);
                    if (action != null) {
                        if (chunk.getByteCount() < 0) {
                            action.complete();
                        } else {
                            action.writeBytes(chunk);
                        }
                    } else {
                        throw new IllegalStateException("No action for " + item);
                    }
                }
            } else {
                throw new NotSynchronizedException();
            }
        }

        public ByteChunk pullBytes(SynchronizationId<ClusterNode> id, RepositoryItemMetadata item) throws NotSynchronizedException, IOException {
            if (!DefaultRepositoryClusteringHandler.this.inSync) {
                throw new NotSynchronizedException();
            }
            ActiveSynchronization active = DefaultRepositoryClusteringHandler.this.activeSynchronization;
            if (active != null) {
                ActiveSynchronization activeSynchronization = active;
                synchronized (activeSynchronization) {
                    active.validate(id);
                    SynchronizationReadAction<?> action = active.getReadAction(item);
                    if (action != null) {
                        return action.getNextBytes();
                    }
                    throw new IllegalStateException("No action for " + item);
                }
            }
            throw new NotSynchronizedException();
        }

        public boolean prepare(SynchronizationId<ClusterNode> id) throws NotSynchronizedException {
            if (!DefaultRepositoryClusteringHandler.this.inSync) {
                throw new NotSynchronizedException();
            }
            return DefaultRepositoryClusteringHandler.this.handlePrepare((SynchronizationId<ClusterNode>)id);
        }

        public void commit(SynchronizationId<ClusterNode> id) {
            if (DefaultRepositoryClusteringHandler.this.inSync) {
                DefaultRepositoryClusteringHandler.this.handleCommit((SynchronizationId<ClusterNode>)id);
            }
        }

        public void rollback(SynchronizationId<ClusterNode> id) throws NotSynchronizedException {
            if (DefaultRepositoryClusteringHandler.this.inSync) {
                DefaultRepositoryClusteringHandler.this.handleRollback((SynchronizationId<ClusterNode>)id);
            }
        }
    }
}

