/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.iiop;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashMap;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.iiop.IORFactory;
import org.jboss.ejb3.proxy.factory.SessionProxyFactory;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.iiop.CorbaORB;
import org.jboss.iiop.csiv2.SASCurrent;
import org.jboss.iiop.rmi.AttributeAnalysis;
import org.jboss.iiop.rmi.InterfaceAnalysis;
import org.jboss.iiop.rmi.OperationAnalysis;
import org.jboss.iiop.rmi.RmiIdlUtil;
import org.jboss.iiop.rmi.marshal.strategy.SkeletonStrategy;
import org.jboss.iiop.tm.InboundTransactionCurrent;
import org.jboss.invocation.iiop.ReferenceData;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.tm.TransactionManagerLocator;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.PortableServer.Current;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class BeanCorbaServant
extends Servant
implements InvokeHandler {
    private static final Logger log = Logger.getLogger(BeanCorbaServant.class);
    private final IORFactory factory;
    private final Current poaCurrent;
    private final Container container;
    private final InterfaceDef interfaceDef;
    private final String[] repositoryIds;
    private SASCurrent sasCurrent;
    private InboundTransactionCurrent inboundTxCurrent;
    private HashMap<String, SkeletonStrategy> methodMap;

    protected BeanCorbaServant(IORFactory factory, Current poaCurrent, Container container, InterfaceDef interfaceDef, InterfaceAnalysis interfaceAnalysis) {
        assert (factory != null) : "factory is null";
        assert (poaCurrent != null) : "poaCurrent is null";
        assert (container != null) : "container is null";
        assert (container instanceof SessionContainer) : "only SessionContainer supported";
        assert (interfaceAnalysis != null) : "interfaceAnalysis is null";
        this.factory = factory;
        this.poaCurrent = poaCurrent;
        this.container = container;
        this.interfaceDef = interfaceDef;
        this.repositoryIds = interfaceAnalysis.getAllTypeIds();
        try {
            this.sasCurrent = (SASCurrent)CorbaORB.getInstance().resolve_initial_references("SASCurrent");
        }
        catch (InvalidName e) {
            log.warn((java.lang.Object)"Can't find SASCurrent");
            this.sasCurrent = null;
        }
        try {
            this.inboundTxCurrent = (InboundTransactionCurrent)CorbaORB.getInstance().resolve_initial_references("InboundTransactionCurrent");
        }
        catch (InvalidName e) {
            log.warn((java.lang.Object)"Can't find InboundTransactionCurrent");
            this.inboundTxCurrent = null;
        }
        this.methodMap = new HashMap();
        AttributeAnalysis[] attrs = interfaceAnalysis.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            OperationAnalysis op = attrs[i].getAccessorAnalysis();
            log.debug((java.lang.Object)("    " + op.getJavaName() + ": " + op.getIDLName()));
            this.methodMap.put(op.getIDLName(), new SkeletonStrategy(op.getMethod()));
            op = attrs[i].getMutatorAnalysis();
            if (op == null) continue;
            log.debug((java.lang.Object)("    " + op.getJavaName() + ": " + op.getIDLName()));
            this.methodMap.put(op.getIDLName(), new SkeletonStrategy(op.getMethod()));
        }
        OperationAnalysis[] ops = interfaceAnalysis.getOperations();
        for (int i = 0; i < ops.length; ++i) {
            log.debug((java.lang.Object)("    " + ops[i].getJavaName() + ": " + ops[i].getIDLName()));
            this.methodMap.put(ops[i].getIDLName(), new SkeletonStrategy(ops[i].getMethod()));
        }
    }

    public String[] _all_interfaces(POA poa, byte[] objectId) {
        return (String[])this.repositoryIds.clone();
    }

    public Object _get_interface_def() {
        if (this.interfaceDef != null) {
            return this.interfaceDef;
        }
        return super._get_interface_def();
    }

    public org.omg.CORBA.portable.OutputStream _invoke(String opName, org.omg.CORBA.portable.InputStream in, ResponseHandler handler) throws SystemException {
        OutputStream out;
        log.trace((java.lang.Object)("invoke: " + opName));
        SkeletonStrategy op = this.methodMap.get(opName);
        if (op == null) {
            log.debug((java.lang.Object)("Unable to find opname '" + opName + "' valid operations:" + this.methodMap.keySet()));
            throw new BAD_OPERATION(opName);
        }
        try {
            java.lang.Object id = ReferenceData.extractObjectId((byte[])this.poaCurrent.get_object_id());
            log.trace((java.lang.Object)("id = " + id));
            Transaction tx = null;
            if (this.inboundTxCurrent != null) {
                tx = this.inboundTxCurrent.getCurrentTransaction();
            }
            log.trace((java.lang.Object)("tx = " + tx));
            if (this.sasCurrent != null) {
                byte[] username = this.sasCurrent.get_incoming_username();
                byte[] credentials = this.sasCurrent.get_incoming_password();
                byte[] principalName = this.sasCurrent.get_incoming_principal_name();
                if (username != null && username.length > 0) {
                    String name = new String(username, "UTF-8");
                    int domainIndex = name.lastIndexOf("@");
                    if (domainIndex > 0) {
                        name = name.substring(0, domainIndex);
                    }
                    log.debug((java.lang.Object)("username = " + name));
                    SimplePrincipal principal = new SimplePrincipal(name);
                    SecurityAssociation.setPrincipal((Principal)principal);
                }
                if (credentials != null && credentials.length > 0) {
                    SecurityAssociation.setCredential((java.lang.Object)new String(credentials, "UTF-8").toCharArray());
                }
                if (principalName != null && principalName.length > 0) {
                    log.warn((java.lang.Object)("principalName = " + new String(principalName, "UTF-8")));
                }
            }
            java.lang.Object[] args = op.readParams((InputStream)in);
            java.lang.Object retVal = this.invoke(tx, id, op.getMethod(), args);
            out = (OutputStream)handler.createReply();
            if (op.isNonVoid()) {
                op.writeRetval(out, retVal);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (t instanceof Exception) {
                Exception e = (Exception)t;
                RmiIdlUtil.rethrowIfCorbaSystemException((Exception)e);
                out = (OutputStream)handler.createExceptionReply();
                op.writeException(out, e);
            }
            throw new RuntimeException("NYI");
        }
        return out;
    }

    private TransactionManager getTransactionManager() {
        return TransactionManagerLocator.getInstance().locate();
    }

    private java.lang.Object invoke(java.lang.Object id, Method method, java.lang.Object[] args) throws Throwable {
        return ((SessionContainer)this.container).invoke((SessionProxyFactory)this.factory, id, method, args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private java.lang.Object invoke(Transaction tx, java.lang.Object id, Method method, java.lang.Object[] args) throws Throwable {
        if (tx == null) {
            return this.invoke(id, method, args);
        }
        TransactionManager tm = this.getTransactionManager();
        if (tm.getTransaction() != null) {
            throw new RuntimeException("cannot import a transaction context when a transaction is already associated with the thread");
        }
        tm.resume(tx);
        try {
            java.lang.Object object = this.invoke(id, method, args);
            return object;
        }
        finally {
            tm.suspend();
        }
    }
}

