/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.deployers.spi.AttachmentNames;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.profileservice.profile.metadata.BasicProfileMetaData;
import org.jboss.profileservice.profile.metadata.helpers.ProfileMetaDataFactory;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJB3MetadataOnDemandDeploymentDeployer
extends AbstractDeployer {
    private static final Logger log = Logger.getLogger(EJB3MetadataOnDemandDeploymentDeployer.class);
    private static final String DEFAULT_EJB3_ONDEMAND_PROFILE_NAME = "EJB3_OnDemand_Profile";
    private ProfileService profileService;
    private URI deploymentRoot;
    private Collection<String> deploymentNames;
    private boolean activated;
    private String profileDomain;
    private String profileServer;
    private String profileName;
    private ProfileKey profileKey;
    private boolean activateOnDemand = true;

    public EJB3MetadataOnDemandDeploymentDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.setInput(JBossMetaData.class);
        this.addInput(AttachmentNames.PROCESSED_METADATA);
    }

    public URI getDeploymentRoot() {
        return this.deploymentRoot;
    }

    public void setDeploymentRoot(URI deploymentRoot) {
        this.deploymentRoot = deploymentRoot;
    }

    public Collection<String> getDeploymentNames() {
        return this.deploymentNames;
    }

    public void setDeploymentNames(Collection<String> deploymentNames) {
        this.deploymentNames = deploymentNames;
    }

    public void setSingleDeployment(String name) {
        this.deploymentNames = Collections.singleton(name);
    }

    public String getProfileDomain() {
        return this.profileDomain;
    }

    public void setProfileDomain(String profileDomain) {
        this.profileDomain = profileDomain;
    }

    public String getProfileServer() {
        return this.profileServer;
    }

    public void setProfileServer(String profileServer) {
        this.profileServer = profileServer;
    }

    public String getProfileName() {
        if (this.profileName == null) {
            this.profileName = DEFAULT_EJB3_ONDEMAND_PROFILE_NAME;
        }
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setProfileService(ProfileService profileService) {
        if (profileService == null) {
            throw new IllegalArgumentException("profileService is null");
        }
        this.profileService = profileService;
    }

    public boolean isActivateOnDemand() {
        return this.activateOnDemand;
    }

    public void setActivateOnDemand(boolean activateOnDemand) {
        this.activateOnDemand = activateOnDemand;
    }

    public void start() throws Exception {
        if (this.profileService == null) {
            throw new IllegalStateException("Must configure ProfileService");
        }
        if (this.deploymentRoot == null) {
            throw new IllegalStateException("Must configure deployment root");
        }
        if (this.deploymentNames == null || this.deploymentNames.isEmpty()) {
            throw new IllegalStateException("Must configure deployment name(s)");
        }
        String[] rootSubProfiles = new String[]{};
        BasicProfileMetaData profileMetaData = ProfileMetaDataFactory.createFilteredProfileMetaData((String)this.getProfileName(), (URI)this.deploymentRoot, (String[])this.deploymentNames.toArray(new String[this.deploymentNames.size()]));
        this.profileKey = this.profileService.registerProfile((ProfileMetaData)profileMetaData);
        if (!this.activateOnDemand) {
            this.activateProfile(false);
        }
    }

    public void stop() throws Exception {
        ProfileKey profKey = null;
        try {
            profKey = this.getProfileKey();
        }
        catch (IllegalStateException e) {
            return;
        }
        if (this.profileService != null && profKey != null) {
            try {
                if (this.profileService.getActiveProfileKeys().contains(profKey)) {
                    this.releaseProfile();
                }
                this.profileService.unregisterProfile(profKey);
            }
            catch (NoSuchProfileException e) {
                log.warn((Object)("Could not unregister unknown profile " + profKey));
            }
        }
    }

    public void activateProfile() throws Exception {
        this.activateProfile(true);
    }

    public ProfileKey getProfileKey() {
        if (this.profileKey == null) {
            String profileName = this.getProfileName();
            if (profileName == null) {
                throw new IllegalStateException("Must configure profileName or contextName before calling getProfileKey()");
            }
            this.profileKey = new ProfileKey(this.getProfileDomain(), this.getProfileServer(), profileName);
        }
        return this.profileKey;
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (this.isActivated()) {
            return;
        }
        JBossMetaData metadata = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        if (!metadata.isEJB3x()) {
            return;
        }
        try {
            this.activateProfile(true);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not activate on-demand profile: " + this.getProfileName() + " while deploying unit: " + unit);
        }
    }

    private synchronized void activateProfile(boolean validate) throws Exception {
        if (this.profileService == null) {
            throw new IllegalStateException("Must configure the ProfileService");
        }
        ProfileKey profKey = this.getProfileKey();
        if (!this.profileService.getActiveProfileKeys().contains(profKey)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Activating on-demand profile: " + profKey));
            }
            this.profileService.activateProfile(profKey);
            if (validate) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Validating on-demand profile: " + profKey));
                }
                this.profileService.validateProfile(profKey);
            }
            this.activated = true;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Profile " + profKey + " is already activated"));
            }
            this.activated = true;
        }
    }

    private synchronized void releaseProfile() throws Exception {
        if (this.activated) {
            try {
                this.profileService.deactivateProfile(this.getProfileKey());
            }
            catch (NoSuchProfileException e) {
                log.warn((Object)("Can't deactivate profile since no Profile is registered under key " + this.getProfileKey()));
            }
            this.activated = false;
        }
    }
}

