/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import javax.transaction.TransactionManager;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployerWithInput;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.plugins.dependency.DependenciesMetaData;
import org.jboss.deployers.vfs.plugins.dependency.DependencyItemMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3DependenciesDeployer
extends AbstractRealDeployerWithInput<JBossMetaData> {
    public Ejb3DependenciesDeployer() {
        this.setStage(DeploymentStages.PRE_REAL);
        this.setOutput(DependenciesMetaData.class);
        DeploymentVisitor<JBossMetaData> visitor = new DeploymentVisitor<JBossMetaData>(){

            public void deploy(DeploymentUnit unit, JBossMetaData deployment) throws DeploymentException {
                if (!deployment.isEJB3x()) {
                    return;
                }
                if (Ejb3DependenciesDeployer.this.log.isTraceEnabled()) {
                    Ejb3DependenciesDeployer.this.log.trace((Object)("Encountered EJB3 deployment " + unit));
                }
                unit.addIDependOn((DependencyItem)new AbstractDependencyItem((Object)unit.getName(), TransactionManager.class, ControllerState.getInstance((String)"Real"), ControllerState.INSTALLED));
            }

            private DependencyItemMetaData createDependencyItemMetaData(String name) {
                DependencyItemMetaData item = new DependencyItemMetaData();
                item.setValue((Object)name);
                item.setWhenRequired(ControllerState.getInstance((String)"Real"));
                item.setDependentState(ControllerState.INSTALLED);
                return item;
            }

            public Class<JBossMetaData> getVisitorType() {
                return JBossMetaData.class;
            }

            public void undeploy(DeploymentUnit unit, JBossMetaData deployment) {
            }
        };
        this.setDeploymentVisitor((DeploymentVisitor)visitor);
    }
}

