/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.VisitorAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlesTypesClassFilter
implements VirtualFileVisitor {
    private static Logger log = Logger.getLogger(HandlesTypesClassFilter.class);
    private ClassLoader loader;
    private int rootLength;
    private HashSet<String> childPaths = new HashSet();
    private Map<ServletContainerInitializer, Set<Class<?>>> handlesTypes;
    private Class<?>[] typesArray;
    private Map<Class<?>, Set<ServletContainerInitializer>> typesMap;

    public HandlesTypesClassFilter(VFSDeploymentUnit unit, ClassLoader loader, VirtualFile classpathRoot, Class<?>[] typesArray, Map<Class<?>, Set<ServletContainerInitializer>> typesMap, Map<ServletContainerInitializer, Set<Class<?>>> handlesTypes) {
        List children;
        this.loader = loader;
        this.handlesTypes = handlesTypes;
        this.typesArray = typesArray;
        this.typesMap = typesMap;
        String rootName = classpathRoot.getPathName();
        this.rootLength = rootName.length();
        if (this.rootLength > 0) {
            ++this.rootLength;
        }
        if ((children = unit.getChildren()) != null) {
            for (DeploymentUnit cu : children) {
                String path = cu.getName();
                this.childPaths.add(path);
            }
        }
    }

    public VisitorAttributes getAttributes() {
        VisitorAttributes attributes = new VisitorAttributes();
        attributes.setIncludeRoot(true);
        attributes.setRecurseFilter((VirtualFileFilter)new NoChildFilter());
        return attributes;
    }

    public void visit(VirtualFile file) {
        try {
            if (file.isLeaf()) {
                this.accepts(file);
            }
        }
        catch (IOException e) {
            throw new Error("Error visiting " + file, e);
        }
    }

    public boolean accepts(VirtualFile file) {
        boolean accepts;
        block6: {
            accepts = file.getPathName().endsWith(".class");
            if (accepts) {
                accepts = false;
                String className = null;
                try {
                    className = this.getClassName(file);
                    Class<?> c = this.loader.loadClass(className);
                    for (Class<?> clazz : this.typesArray) {
                        if ((!clazz.isAnnotation() || !c.isAnnotationPresent(clazz)) && !clazz.isAssignableFrom(c)) continue;
                        Set<ServletContainerInitializer> sciSet = this.typesMap.get(clazz);
                        for (ServletContainerInitializer sci : sciSet) {
                            this.handlesTypes.get(sci).add(c);
                        }
                    }
                }
                catch (NoClassDefFoundError ignored) {
                    log.debug((Object)("Incomplete class: " + className + ", NCDFE: " + ignored));
                }
                catch (Exception ignored) {
                    if (!log.isTraceEnabled()) break block6;
                    log.trace((Object)("Failed to load class: " + className), (Throwable)ignored);
                }
            }
        }
        return accepts;
    }

    protected String getFilePath(VirtualFile file) {
        String path = null;
        try {
            path = file.toURI().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    protected String getClassName(VirtualFile classFile) throws IOException {
        String pathName = classFile.getPathName();
        String name = pathName.substring(this.rootLength, pathName.length() - 6);
        name = name.replace('/', '.');
        return name;
    }

    class NoChildFilter
    implements VirtualFileFilter {
        NoChildFilter() {
        }

        public boolean accepts(VirtualFile file) {
            String path = HandlesTypesClassFilter.this.getFilePath(file);
            boolean accepts = false;
            try {
                accepts = !file.isLeaf() && !HandlesTypesClassFilter.this.childPaths.contains(path);
            }
            catch (Exception e) {
                // empty catch block
            }
            return accepts;
        }
    }
}

