/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.mbean;

import com.arjuna.ats.arjuna.AtomicAction;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.RecordList;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.tools.osb.mbean.ActionBeanMBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.ActionBeanWrapperInterface;
import com.arjuna.ats.arjuna.tools.osb.mbean.LogRecordWrapper;
import com.arjuna.ats.arjuna.tools.osb.mbean.OSEntryBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.ParticipantStatus;
import com.arjuna.ats.arjuna.tools.osb.mbean.StateManagerWrapper;
import com.arjuna.ats.arjuna.tools.osb.mbean.UidWrapper;
import com.arjuna.ats.arjuna.tools.osb.util.JMXServer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ActionBean
extends OSEntryBean
implements ActionBeanMBean {
    private StateManagerWrapper sminfo;
    private Collection<LogRecordWrapper> participants = new ArrayList<LogRecordWrapper>();
    private ActionBeanWrapperInterface ra;

    public ActionBean(UidWrapper w) {
        super(w);
        boolean isJTS = JMXServer.isJTS() && w.getType().endsWith("ArjunaTransactionImple");
        List<UidWrapper> recuids = null;
        if (isJTS) {
            try {
                Class<?> cl = Class.forName(JMXServer.AJT_WRAPPER_TYPE);
                Constructor<?> constructor = cl.getConstructor(ActionBean.class, UidWrapper.class);
                this.ra = (ActionBeanWrapperInterface)constructor.newInstance(this, w);
            }
            catch (Exception e) {
                if (tsLogger.logger.isTraceEnabled()) {
                    tsLogger.logger.trace((Object)("Error constructing " + JMXServer.AJT_WRAPPER_TYPE + ": " + e));
                }
                this.ra = new AtomicActionWrapper(w);
            }
        } else {
            this.ra = new AtomicActionWrapper(w);
        }
        this.ra.activate();
        this.sminfo = new StateManagerWrapper(StoreManager.getRecoveryStore(), this.getUid(), this.getType());
        if (isJTS) {
            recuids = w.probe(JMXServer.AJT_RECORD_TYPE, JMXServer.AJT_XAREC_TYPE);
        }
        for (ParticipantStatus lt : ParticipantStatus.values()) {
            this.findParticipants(recuids, this.ra.getRecords(lt), lt);
        }
    }

    @Override
    public StringBuilder toString(String prefix, StringBuilder sb) {
        this.ra.toString(prefix, sb);
        prefix = prefix + '\t';
        sb.append('\n').append(prefix).append(this.sminfo.getCreationTime());
        sb.append('\n').append(prefix).append(this.sminfo.getAgeInSeconds());
        for (LogRecordWrapper p : this.participants) {
            p.toString(prefix, sb);
        }
        return sb;
    }

    @Override
    public Uid getUid(AbstractRecord rec) {
        return this.ra.getUid(rec);
    }

    @Override
    public String remove() {
        try {
            if (!StoreManager.getRecoveryStore().remove_committed(this.getUid(), this.getType())) {
                return "remove committed failed";
            }
            this.w.probe();
            return "remove ok";
        }
        catch (ObjectStoreException e) {
            return "remove committed exception: " + e.getMessage();
        }
    }

    private void findParticipants(List<UidWrapper> recuids, RecordList list2, ParticipantStatus listType) {
        if (list2 != null) {
            AbstractRecord rec = list2.peekFront();
            while (rec != null) {
                LogRecordWrapper lw;
                int i;
                int n = i = recuids == null ? -1 : recuids.indexOf(new UidWrapper(this.ra.getUid(rec)));
                if (i != -1) {
                    OSEntryBean p = recuids.get(i).getMBean();
                    if (p instanceof LogRecordWrapper) {
                        lw = (LogRecordWrapper)p;
                        lw.init(this, rec, listType);
                    } else {
                        if (tsLogger.logger.isTraceEnabled()) {
                            tsLogger.logger.trace((Object)"participant record is not a LogRecordWrapper");
                        }
                        lw = this.createParticipant(rec, listType);
                    }
                } else {
                    lw = this.createParticipant(rec, listType);
                }
                lw.activate();
                this.participants.add(lw);
                rec = list2.peekNext(rec);
            }
        }
    }

    protected LogRecordWrapper createParticipant(AbstractRecord rec, ParticipantStatus listType) {
        return new LogRecordWrapper(this, rec, listType);
    }

    public LogRecordWrapper getParticipant(AbstractRecord rec) {
        for (LogRecordWrapper w : this.participants) {
            if (!w.getRecord().equals(rec)) continue;
            return w;
        }
        return null;
    }

    @Override
    public void register() {
        super.register();
        for (LogRecordWrapper p : this.participants) {
            JMXServer.getAgent().registerMBean(p.getName(), p);
        }
    }

    @Override
    public void unregister() {
        for (LogRecordWrapper p : this.participants) {
            JMXServer.getAgent().unregisterMBean(p.getName());
        }
        super.unregister();
    }

    @Override
    public long getAgeInSeconds() {
        return this.sminfo.getAgeInSeconds();
    }

    @Override
    public String getCreationTime() {
        return this.sminfo.getCreationTime();
    }

    @Override
    public boolean isParticipant() {
        return false;
    }

    public boolean setStatus(LogRecordWrapper logrec, ParticipantStatus newStatus) {
        ParticipantStatus lt = logrec.getListType();
        AbstractRecord targRecord = logrec.getRecord();
        RecordList oldList = this.ra.getRecords(lt);
        RecordList newList = this.ra.getRecords(newStatus);
        if (lt.equals((Object)ParticipantStatus.HEURISTIC) && !targRecord.forgetHeuristic()) {
            return false;
        }
        if (oldList.remove(targRecord) && newList.insert(targRecord)) {
            if (lt.equals((Object)ParticipantStatus.HEURISTIC)) {
                switch (newStatus) {
                    case FAILED: {
                        this.ra.clearHeuristicDecision(8);
                        break;
                    }
                    case PENDING: {
                        this.ra.clearHeuristicDecision(9);
                        break;
                    }
                    case PREPARED: {
                        this.ra.clearHeuristicDecision(0);
                        break;
                    }
                    case READONLY: {
                        this.ra.clearHeuristicDecision(2);
                        break;
                    }
                }
            }
            this.ra.doUpdateState();
            return true;
        }
        return false;
    }

    public Collection<LogRecordWrapper> getParticipants() {
        return Collections.unmodifiableCollection(this.participants);
    }

    class AtomicActionWrapper
    extends AtomicAction
    implements ActionBeanWrapperInterface {
        boolean activated;

        public AtomicActionWrapper(UidWrapper w) {
            super(w.getUid());
        }

        @Override
        public boolean activate() {
            if (!this.activated) {
                this.activated = super.activate();
            }
            return this.activated;
        }

        @Override
        public void doUpdateState() {
            this.updateState();
        }

        @Override
        public Uid getUid(AbstractRecord rec) {
            return this.get_uid();
        }

        @Override
        public StringBuilder toString(String prefix, StringBuilder sb) {
            prefix = prefix + '\t';
            return sb.append('\n').append(prefix).append(this.get_uid());
        }

        @Override
        public void clearHeuristicDecision(int newDecision) {
            if (this.heuristicList.size() == 0) {
                this.setHeuristicDecision(newDecision);
            }
        }

        @Override
        public RecordList getRecords(ParticipantStatus type) {
            switch (type) {
                default: {
                    return this.preparedList;
                }
                case FAILED: {
                    return this.failedList;
                }
                case HEURISTIC: {
                    return this.heuristicList;
                }
                case PENDING: {
                    return this.pendingList;
                }
                case READONLY: 
            }
            return this.readonlyList;
        }
    }
}

