/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.mbean;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.tools.osb.mbean.ActionBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.LogRecordWrapperMBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.OSEntryBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.ParticipantStatus;

public class LogRecordWrapper
extends OSEntryBean
implements LogRecordWrapperMBean {
    protected ActionBean parent;
    protected AbstractRecord rec;
    protected boolean activated;
    protected ParticipantStatus listType;
    protected String objName;

    public LogRecordWrapper(Uid uid) {
        this.objName = "type=unitialised,puid=" + uid.fileStringForm();
    }

    public LogRecordWrapper(ActionBean parent, AbstractRecord rec, ParticipantStatus listType) {
        this.init(parent, rec, listType);
    }

    public void init(ActionBean parent, AbstractRecord rec, ParticipantStatus listType) {
        this.parent = parent;
        this.rec = rec;
        this.listType = listType;
        this.objName = parent.getName() + ",puid=" + rec.order().fileStringForm();
    }

    @Override
    public String getName() {
        return this.objName;
    }

    @Override
    public boolean isParticipant() {
        return true;
    }

    @Override
    public String getStatus() {
        return this.listType.toString();
    }

    @Override
    public void setStatus(String newState) {
        this.doSetStatus(newState);
    }

    @Override
    public String clearHeuristic() {
        return this.doSetStatus("PREPARED");
    }

    public String doSetStatus(String newState) {
        try {
            return this.setStatus(Enum.valueOf(ParticipantStatus.class, newState.toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            StringBuilder sb = new StringBuilder("Valid status values are: ");
            for (ParticipantStatus lt : ParticipantStatus.values()) {
                sb.append(lt.name()).append(", ");
            }
            sb.append(" and only HEURISTIC and PREPARED will persist after JVM restart.");
            return sb.toString();
        }
    }

    public String setStatus(ParticipantStatus newState) {
        if (this.parent != null && this.parent.setStatus(this, newState)) {
            this.listType = newState;
            return "status change was successful";
        }
        return "failed";
    }

    @Override
    public String getType() {
        return this.rec == null ? "uninitialised" : this.rec.type();
    }

    public AbstractRecord getRecord() {
        return this.rec;
    }

    public ParticipantStatus getListType() {
        return this.listType;
    }

    @Override
    public boolean activate() {
        if (!this.activated && this.rec != null) {
            this.activated = this.rec.activate();
        }
        return this.activated;
    }

    @Override
    public StringBuilder toString(String prefix, StringBuilder sb) {
        prefix = prefix + "\t";
        if (this.parent != null && this.rec != null) {
            sb.append('\n').append(prefix).append(this.parent.getUid(this.rec));
            sb.append('\n').append(prefix).append(this.listType.toString());
            sb.append('\n').append(prefix).append(this.rec.type());
            sb.append('\n').append(prefix).append(this.parent.getCreationTime());
            sb.append('\n').append(prefix).append(this.parent.getAgeInSeconds());
        } else {
            sb.append('\n').append(prefix).append(this.objName);
        }
        return sb;
    }

    public String callMethod(Object object, String mName) {
        try {
            return (String)object.getClass().getMethod(mName, new Class[0]).invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return "Not supported";
        }
        catch (Exception e) {
            return "Error: " + e.getMessage();
        }
    }

    public boolean isHeuristic() {
        return this.listType.equals((Object)ParticipantStatus.HEURISTIC);
    }
}

