/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jts.extensions;

import com.arjuna.ats.internal.jts.OTSImpleManager;
import com.arjuna.ats.internal.jts.orbspecific.CurrentImple;
import com.arjuna.ats.jts.extensions.AtomicTransaction;
import com.arjuna.ats.jts.logging.jtsLogger;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.WrongTransaction;

public class TopLevelTransaction
extends AtomicTransaction {
    private Control _originalTransaction;

    public TopLevelTransaction() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"TopLevelTransaction::TopLevelTransaction ()");
        }
        this._originalTransaction = null;
    }

    @Override
    public void finalize() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"TopLevelTransaction.finalize ()");
        }
        if (this._originalTransaction != null) {
            String name = null;
            Coordinator coord = null;
            try {
                coord = this._originalTransaction.get_coordinator();
                if (coord != null) {
                    name = coord.get_transaction_name();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            coord = null;
            jtsLogger.i18NLogger.warn_extensions_tltnestedscope(name != null ? name : "UNKNOWN");
            name = null;
            this._originalTransaction = null;
        }
        super.finalize();
    }

    @Override
    public synchronized void begin() throws SystemException, SubtransactionsUnavailable {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"TopLevelTransaction::begin ()");
        }
        if (this._originalTransaction != null) {
            throw new INVALID_TRANSACTION();
        }
        CurrentImple current = OTSImpleManager.current();
        this._originalTransaction = current.suspend();
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("TopLevelTransaction::begin - suspend transaction " + this._originalTransaction));
        }
        super.begin();
    }

    @Override
    public synchronized void commit(boolean report_heuristics) throws SystemException, NoTransaction, HeuristicMixed, HeuristicHazard, WrongTransaction {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("TopLevelTransaction::commit ( " + report_heuristics + " ) called for " + this._originalTransaction));
        }
        if (this.validTransaction()) {
            try {
                super.commit(report_heuristics);
            }
            catch (WrongTransaction e1) {
                this.resumeTransaction();
                throw e1;
            }
            catch (SystemException e2) {
                this.resumeTransaction();
                throw e2;
            }
        } else {
            throw new WrongTransaction();
        }
        this.resumeTransaction();
    }

    @Override
    public synchronized void rollback() throws SystemException, NoTransaction, WrongTransaction {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("TopLevelTransaction::rollback () called for " + this._originalTransaction));
        }
        if (this.validTransaction()) {
            try {
                super.rollback();
            }
            catch (WrongTransaction e1) {
                this.resumeTransaction();
                throw e1;
            }
            catch (SystemException e2) {
                this.resumeTransaction();
                throw e2;
            }
        } else {
            throw new WrongTransaction();
        }
        this.resumeTransaction();
    }

    private final void resumeTransaction() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("TopLevelTransaction::resumeTransaction for " + this._originalTransaction));
        }
        try {
            if (this._originalTransaction != null) {
                CurrentImple current = OTSImpleManager.current();
                current.resume(this._originalTransaction);
                this._originalTransaction = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

