/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.orbportability.internal.utils;

import com.arjuna.orbportability.common.opPropertyManager;
import com.arjuna.orbportability.logging.opLogger;
import com.arjuna.orbportability.utils.InitClassInterface;
import java.util.Map;

abstract class InitLoader {
    private String initName;
    private String propertyName;
    private Object initObj;

    protected InitLoader(String name, String attrName, Object obj) {
        this.initName = name;
        this.propertyName = attrName;
        this.initObj = obj;
    }

    protected void initialise() {
        Map<String, String> properties = opPropertyManager.getOrbPortabilityEnvironmentBean().getOrbInitializationProperties();
        for (String attrName : properties.keySet()) {
            if (attrName.indexOf(this.propertyName) == -1) continue;
            this.createInstance(attrName, properties.get(attrName));
        }
    }

    private void createInstance(String attrName, String className) {
        if (className == null) {
            opLogger.i18NLogger.warn_internal_utils_InitLoader_initfailed(this.initName, attrName);
            return;
        }
        try {
            opLogger.i18NLogger.info_internal_utils_InitLoader_loading(this.initName, className);
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(className);
            try {
                Object o = c.newInstance();
                if (o instanceof InitClassInterface) {
                    ((InitClassInterface)o).invoke(this.initObj);
                }
                o = null;
            }
            catch (IllegalAccessException e1) {
                opLogger.i18NLogger.warn_internal_utils_InitLoader_exception(this.initName, e1);
            }
            catch (InstantiationException e2) {
                opLogger.i18NLogger.warn_internal_utils_InitLoader_exception(this.initName, e2);
            }
            c = null;
        }
        catch (ClassNotFoundException e) {
            opLogger.i18NLogger.warn_internal_utils_InitLoader_couldnotfindclass(this.initName, className);
        }
    }
}

