/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.dependency.plugins.AbstractControllerStateModel;
import org.jboss.dependency.spi.ControllerState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapControllerStateModel
extends AbstractControllerStateModel {
    private volatile ControllerStateWrapper first;
    private volatile ControllerStateWrapper last;
    private final Map<ControllerState, ControllerStateWrapper> states = new ConcurrentHashMap<ControllerState, ControllerStateWrapper>(16, 0.75f, 1);
    private final List<ControllerState> stateList = new CopyOnWriteArrayList<ControllerState>();

    @Override
    public synchronized boolean addState(ControllerState state, ControllerState before) {
        int index;
        ControllerStateWrapper previous;
        ControllerStateWrapper next;
        if (this.states.containsKey(state)) {
            return false;
        }
        if (before == null) {
            next = null;
            previous = this.last;
            index = this.last == null ? 0 : this.last.getIndex() + 1;
        } else {
            next = this.getState(before);
            previous = next.getBefore();
            index = next.getIndex();
        }
        ControllerStateWrapper newState = new ControllerStateWrapper(state, index, previous, next);
        this.states.put(state, newState);
        this.stateList.add(index, state);
        if (previous == null) {
            this.first = newState;
        }
        if (next == null) {
            this.last = newState;
        }
        if (next != null) {
            for (ControllerStateWrapper current = this.last; current != null; current = current.getBefore()) {
                current.incrementIndex();
                if (current == next) break;
            }
        }
        if (next != null) {
            next.setBefore(newState);
        }
        if (previous != null) {
            previous.setAfter(newState);
        }
        return true;
    }

    protected ControllerStateWrapper getState(ControllerState state) {
        return this.getState(state, false);
    }

    protected ControllerStateWrapper getState(ControllerState state, boolean allowNotFound) {
        if (state == null) {
            throw new IllegalArgumentException("Null state");
        }
        ControllerStateWrapper found = this.states.get(state);
        if (found == null && !allowNotFound) {
            throw new IllegalArgumentException("No such state " + state + " in states " + this.states);
        }
        return found;
    }

    protected int getStateIndex(ControllerState state) {
        return this.getStateIndex(state, false);
    }

    protected int getStateIndex(ControllerState state, boolean allowNotFound) {
        ControllerStateWrapper stateWrapper = this.getState(state, allowNotFound);
        return stateWrapper == null ? -1 : stateWrapper.getIndex();
    }

    @Override
    public ControllerState getPreviousState(ControllerState state) {
        ControllerStateWrapper previous = this.getState(state).getBefore();
        return previous == null ? null : previous.getState();
    }

    @Override
    public ControllerState getNextState(ControllerState state) {
        ControllerStateWrapper next = this.getState(state).getAfter();
        return next == null ? null : next.getState();
    }

    @Override
    public boolean isBeforeState(ControllerState state, ControllerState reference) {
        int referenceIndex;
        int stateIndex = this.getStateIndex(state, true);
        return stateIndex < (referenceIndex = this.getStateIndex(reference, true));
    }

    @Override
    public boolean isAfterState(ControllerState state, ControllerState reference) {
        int referenceIndex;
        int stateIndex = this.getStateIndex(state, true);
        return stateIndex > (referenceIndex = this.getStateIndex(reference, true));
    }

    @Override
    public Iterator<ControllerState> iterator() {
        return this.stateList.iterator();
    }

    @Override
    public ListIterator<ControllerState> listIteraror() {
        return this.stateList.listIterator(this.states.size() - 1);
    }

    @Override
    public boolean isValidState(ControllerState state) {
        return this.states.containsKey(state);
    }

    @Override
    public ControllerState getInitialState() {
        ControllerStateWrapper result = this.first;
        if (result == null) {
            throw new IllegalStateException("No initial state");
        }
        return result.getState();
    }

    private static class ControllerStateWrapper {
        final ControllerState state;
        volatile int index;
        volatile ControllerStateWrapper before;
        volatile ControllerStateWrapper after;

        ControllerStateWrapper(ControllerState state) {
            this.state = state;
        }

        public ControllerStateWrapper(ControllerState state, int index, ControllerStateWrapper before, ControllerStateWrapper after) {
            this(state);
            this.index = index;
            this.before = before;
            this.after = after;
        }

        int getIndex() {
            return this.index;
        }

        void setIndex(int index) {
            this.index = index;
        }

        void incrementIndex() {
            ++this.index;
        }

        ControllerStateWrapper getBefore() {
            return this.before;
        }

        void setBefore(ControllerStateWrapper before) {
            this.before = before;
        }

        ControllerStateWrapper getAfter() {
            return this.after;
        }

        void setAfter(ControllerStateWrapper after) {
            this.after = after;
        }

        ControllerState getState() {
            return this.state;
        }

        public String toString() {
            return "ControllerStateWrapper:state=" + this.state + "; index=" + this.index + "; before=" + this.itemAsString(this.before) + "; after=" + this.itemAsString(this.after);
        }

        String itemAsString(ControllerStateWrapper item) {
            if (item == null) {
                return "null";
            }
            return item.getState().toString();
        }
    }
}

