/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.plugins.jmx;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.Map;

import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperty;

/**
 * Stub class for the RuntimeMXBean interface that is marked up with
 * management annotations.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
@ManagementObject(name=ManagementFactory.RUNTIME_MXBEAN_NAME,
      isRuntime=true,
      componentType=@ManagementComponent(type="MBean", subtype="Platform"),
      targetInterface=RuntimeMXBean.class)
public class RuntimeMXBeanMO implements RuntimeMXBean
{
   @ManagementProperty
   public String getBootClassPath()
   {
      return null;
   }

   @ManagementProperty
   public String getClassPath()
   {
      return null;
   }

   @ManagementProperty
   public List<String> getInputArguments()
   {
      return null;
   }

   @ManagementProperty
   public String getLibraryPath()
   {
      return null;
   }

   @ManagementProperty
   public String getManagementSpecVersion()
   {
      return null;
   }

   @ManagementProperty
   public String getName()
   {
      return null;
   }

   @ManagementProperty
   public String getSpecName()
   {
      return null;
   }

   @ManagementProperty
   public String getSpecVendor()
   {
      return null;
   }

   @ManagementProperty
   public String getSpecVersion()
   {
      return null;
   }

   @ManagementProperty
   public long getStartTime()
   {
      return 0;
   }

   @ManagementProperty
   public Map<String, String> getSystemProperties()
   {
      return null;
   }

   @ManagementProperty
   public long getUptime()
   {
      return 0;
   }

   @ManagementProperty
   public String getVmName()
   {
      return null;
   }

   @ManagementProperty
   public String getVmVendor()
   {
      return null;
   }

   @ManagementProperty
   public String getVmVersion()
   {
      return null;
   }

   @ManagementProperty
   public boolean isBootClassPathSupported()
   {
      return false;
   }

}
