/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

public final class ModularClassTable
implements ClassTable {
    private static final ClassTable.Writer PROXY_WRITER = new ProxyWriter();
    private static final ClassTable.Writer CLASS_WRITER = new ClassWriter();
    private static final ModularClassTable INSTANCE = new ModularClassTable();

    private ModularClassTable() {
    }

    public static ModularClassTable getInstance() {
        return INSTANCE;
    }

    @Override
    public ClassTable.Writer getClassWriter(Class<?> clazz) throws IOException {
        return Proxy.isProxyClass(clazz) ? PROXY_WRITER : CLASS_WRITER;
    }

    @Override
    public Class<?> readClass(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        byte b = unmarshaller.readByte();
        switch (b) {
            case 0: {
                ModuleIdentifier identifier = new ModuleIdentifier((String)unmarshaller.readObject(), (String)unmarshaller.readObject(), (String)unmarshaller.readObject());
                String className = (String)unmarshaller.readObject();
                try {
                    return Module.loadClass((ModuleIdentifier)identifier, (String)className, (boolean)false);
                }
                catch (ModuleLoadException e) {
                    InvalidClassException ce = new InvalidClassException(className, "Module load failed");
                    ce.initCause(e);
                    throw ce;
                }
            }
            case 1: {
                Module module;
                ModuleIdentifier identifier = new ModuleIdentifier((String)unmarshaller.readObject(), (String)unmarshaller.readObject(), (String)unmarshaller.readObject());
                try {
                    module = Module.getModule((ModuleIdentifier)identifier);
                }
                catch (ModuleLoadException e) {
                    InvalidClassException ce = new InvalidClassException("Module load failed");
                    ce.initCause(e);
                    throw ce;
                }
                ModuleClassLoader classLoader = module.getClassLoader();
                int len = unmarshaller.readInt();
                Class[] interfaces = new Class[len];
                for (int i = 0; i < len; ++i) {
                    interfaces[i] = Class.forName((String)unmarshaller.readObject(), false, (ClassLoader)classLoader);
                }
                return Proxy.getProxyClass((ClassLoader)classLoader, interfaces);
            }
        }
        throw new StreamCorruptedException(String.format("Invalid class type byte: %02x", b & 0xFF));
    }

    private static final class ProxyWriter
    implements ClassTable.Writer {
        private ProxyWriter() {
        }

        @Override
        public void writeClass(Marshaller marshaller, Class<?> clazz) throws IOException {
            marshaller.write(1);
            Module module = Module.forClass(clazz);
            if (module == null) {
                throw new InvalidClassException(clazz.getName(), "Class is not present in any module");
            }
            ModuleIdentifier identifier = module.getIdentifier();
            marshaller.writeObject(identifier.getGroup());
            marshaller.writeObject(identifier.getArtifact());
            marshaller.writeObject(identifier.getVersion());
            Class<?>[] interfaces = clazz.getInterfaces();
            marshaller.writeInt(interfaces.length);
            for (Class<?> interfaze : interfaces) {
                marshaller.writeObject(interfaze.getName());
            }
        }
    }

    private static final class ClassWriter
    implements ClassTable.Writer {
        private ClassWriter() {
        }

        @Override
        public void writeClass(Marshaller marshaller, Class<?> clazz) throws IOException {
            marshaller.write(0);
            Module module = Module.forClass(clazz);
            if (module == null) {
                throw new InvalidClassException(clazz.getName(), "Class is not present in any module");
            }
            ModuleIdentifier identifier = module.getIdentifier();
            marshaller.writeObject(identifier.getGroup());
            marshaller.writeObject(identifier.getArtifact());
            marshaller.writeObject(identifier.getVersion());
            marshaller.writeObject(clazz.getName());
        }
    }
}

