/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.river;

import java.io.Externalizable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractQueue;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.river.SerializableClassDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDescriptor {
    private final Class<?> type;
    private int typeID;
    public static final ClassDescriptor STRING_DESCRIPTOR = new ClassDescriptor(String.class, 20);
    public static final ClassDescriptor CLASS_DESCRIPTOR = new ClassDescriptor(Class.class, 21);
    public static final ClassDescriptor OBJECT_DESCRIPTOR = new ClassDescriptor(Object.class, 22);
    public static final ClassDescriptor ENUM_DESCRIPTOR = new ClassDescriptor(Enum.class, 23);
    public static final ClassDescriptor BOOLEAN = new ClassDescriptor(Boolean.TYPE, 32);
    public static final ClassDescriptor BYTE = new ClassDescriptor(Byte.TYPE, 33);
    public static final ClassDescriptor SHORT = new ClassDescriptor(Short.TYPE, 34);
    public static final ClassDescriptor INT = new ClassDescriptor(Integer.TYPE, 35);
    public static final ClassDescriptor LONG = new ClassDescriptor(Long.TYPE, 36);
    public static final ClassDescriptor CHAR = new ClassDescriptor(Character.TYPE, 37);
    public static final ClassDescriptor FLOAT = new ClassDescriptor(Float.TYPE, 38);
    public static final ClassDescriptor DOUBLE = new ClassDescriptor(Double.TYPE, 39);
    public static final ClassDescriptor VOID = new ClassDescriptor(Void.TYPE, 40);
    public static final ClassDescriptor BOOLEAN_OBJ = new ClassDescriptor(Boolean.class, 41);
    public static final ClassDescriptor BYTE_OBJ = new ClassDescriptor(Byte.class, 42);
    public static final ClassDescriptor SHORT_OBJ = new ClassDescriptor(Short.class, 43);
    public static final ClassDescriptor INTEGER_OBJ = new ClassDescriptor(Integer.class, 44);
    public static final ClassDescriptor LONG_OBJ = new ClassDescriptor(Long.class, 45);
    public static final ClassDescriptor CHARACTER_OBJ = new ClassDescriptor(Character.class, 46);
    public static final ClassDescriptor FLOAT_OBJ = new ClassDescriptor(Float.class, 47);
    public static final ClassDescriptor DOUBLE_OBJ = new ClassDescriptor(Double.class, 48);
    public static final ClassDescriptor VOID_OBJ = new ClassDescriptor(Void.class, 49);
    public static final ClassDescriptor BOOLEAN_ARRAY = new ClassDescriptor(boolean[].class, 24);
    public static final ClassDescriptor BYTE_ARRAY = new ClassDescriptor(byte[].class, 25);
    public static final ClassDescriptor SHORT_ARRAY = new ClassDescriptor(short[].class, 26);
    public static final ClassDescriptor INT_ARRAY = new ClassDescriptor(int[].class, 27);
    public static final ClassDescriptor LONG_ARRAY = new ClassDescriptor(long[].class, 28);
    public static final ClassDescriptor CHAR_ARRAY = new ClassDescriptor(char[].class, 29);
    public static final ClassDescriptor FLOAT_ARRAY = new ClassDescriptor(float[].class, 30);
    public static final ClassDescriptor DOUBLE_ARRAY = new ClassDescriptor(double[].class, 31);
    public static final ClassDescriptor ABSTRACT_COLLECTION = new ClassDescriptor(AbstractCollection.class, 109);
    public static final ClassDescriptor ABSTRACT_LIST = new ClassDescriptor(AbstractList.class, 111);
    public static final ClassDescriptor ABSTRACT_QUEUE = new ClassDescriptor(AbstractQueue.class, 112);
    public static final ClassDescriptor ABSTRACT_SEQUENTIAL_LIST = new ClassDescriptor(AbstractSequentialList.class, 113);
    public static final ClassDescriptor ABSTRACT_SET = new ClassDescriptor(AbstractSet.class, 110);
    static final ClassDescriptor CC_ARRAY_LIST = ClassDescriptor.getSerializableClassDescriptor(ArrayList.class);
    static final ClassDescriptor CC_LINKED_LIST = ClassDescriptor.getSerializableClassDescriptor(LinkedList.class);
    static final ClassDescriptor CC_HASH_SET = ClassDescriptor.getSerializableClassDescriptor(HashSet.class);
    static final ClassDescriptor CC_LINKED_HASH_SET = ClassDescriptor.getSerializableClassDescriptor(LinkedHashSet.class);
    static final ClassDescriptor CC_TREE_SET = ClassDescriptor.getSerializableClassDescriptor(TreeSet.class);
    static final ClassDescriptor CC_IDENTITY_HASH_MAP = ClassDescriptor.getSerializableClassDescriptor(IdentityHashMap.class);
    static final ClassDescriptor CC_HASH_MAP = ClassDescriptor.getSerializableClassDescriptor(HashMap.class);
    static final ClassDescriptor CC_HASHTABLE = ClassDescriptor.getSerializableClassDescriptor(Hashtable.class);
    static final ClassDescriptor CC_LINKED_HASH_MAP = ClassDescriptor.getSerializableClassDescriptor(LinkedHashMap.class);
    static final ClassDescriptor CC_TREE_MAP = ClassDescriptor.getSerializableClassDescriptor(TreeMap.class);
    static final ClassDescriptor CC_ENUM_SET = ClassDescriptor.getSerializableClassDescriptor(EnumSet.class);
    static final ClassDescriptor CC_ENUM_MAP = ClassDescriptor.getSerializableClassDescriptor(EnumMap.class);
    static final ClassDescriptor CONCURRENT_HASH_MAP = ClassDescriptor.getSerializableClassDescriptor(ConcurrentHashMap.class);
    static final ClassDescriptor COPY_ON_WRITE_ARRAY_LIST = ClassDescriptor.getSerializableClassDescriptor(CopyOnWriteArrayList.class);
    static final ClassDescriptor COPY_ON_WRITE_ARRAY_SET = ClassDescriptor.getSerializableClassDescriptor(CopyOnWriteArraySet.class);
    static final ClassDescriptor VECTOR = ClassDescriptor.getSerializableClassDescriptor(Vector.class);
    static final ClassDescriptor STACK = ClassDescriptor.getSerializableClassDescriptor(Stack.class);

    private static SerializableClassDescriptor getSerializableClassDescriptor(final Class<?> subject) {
        return AccessController.doPrivileged(new PrivilegedAction<SerializableClassDescriptor>(){

            @Override
            public SerializableClassDescriptor run() {
                SerializableClassRegistry reg = SerializableClassRegistry.getInstance();
                SerializableClass serializableClass = reg.lookup(subject);
                SerializableField[] fields = serializableClass.getFields();
                boolean hasWriteObject = serializableClass.hasWriteObject();
                try {
                    return new SerializableClassDescriptor(serializableClass, null, fields, Externalizable.class.isAssignableFrom(subject) ? 10 : (hasWriteObject ? 56 : 9));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
            }
        });
    }

    public ClassDescriptor(Class<?> type, int typeID) {
        this.type = type;
        this.typeID = typeID;
    }

    public Class<?> getType() {
        return this.type;
    }

    public int getTypeID() {
        return this.typeID;
    }
}

