/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.property;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.metadata.property.PropertyResolver;

public class CompositePropertyResolver
implements PropertyResolver {
    final Collection<PropertyResolver> resolvers;

    public CompositePropertyResolver(Collection<PropertyResolver> resolvers) {
        this.resolvers = resolvers;
    }

    public CompositePropertyResolver(PropertyResolver ... resolvers) {
        this.resolvers = Arrays.asList(resolvers);
    }

    @Override
    public String resolve(String propertyName) {
        String value = null;
        if (this.resolvers != null) {
            Iterator<PropertyResolver> resolverIterator = this.resolvers.iterator();
            while (resolverIterator.hasNext() && value == null) {
                PropertyResolver resolver = resolverIterator.next();
                value = resolver.resolve(propertyName);
            }
        }
        return value;
    }
}

