/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.process.processor.ejb.jboss;

import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.process.ProcessingException;
import org.jboss.metadata.process.processor.JBossMetaDataProcessor;

public class JNDIBindingPolicyProcessor
implements JBossMetaDataProcessor<JBossMetaData> {
    private static Logger logger = Logger.getLogger(JNDIBindingPolicyProcessor.class);

    @Override
    public JBossMetaData process(JBossMetaData metadata) throws ProcessingException {
        JBossEnterpriseBeansMetaData enterpriseBeans = metadata.getEnterpriseBeans();
        if (enterpriseBeans == null || enterpriseBeans.isEmpty()) {
            return metadata;
        }
        for (JBossEnterpriseBeanMetaData enterpriseBean : enterpriseBeans) {
            String jndiBindingPolicyForAllBeansInTheDeployment;
            String jndiBindingPolicyOnBean = enterpriseBean.getJndiBindingPolicy();
            if (jndiBindingPolicyOnBean != null || (jndiBindingPolicyForAllBeansInTheDeployment = metadata.getJndiBindingPolicy()) == null) continue;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Applying jndi-binding-policy " + jndiBindingPolicyForAllBeansInTheDeployment + " to bean named " + enterpriseBean.getEjbName()));
            }
            enterpriseBean.setJndiBindingPolicy(jndiBindingPolicyForAllBeansInTheDeployment);
        }
        return metadata;
    }
}

