/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.spec;

import javax.ejb.TransactionAttributeType;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.parser.spec.AbstractWithDescriptionsParser;
import org.jboss.metadata.ejb.parser.spec.AttributeProcessor;
import org.jboss.metadata.ejb.parser.spec.AttributeProcessorHelper;
import org.jboss.metadata.ejb.parser.spec.EjbJarElement;
import org.jboss.metadata.ejb.parser.spec.IdMetaDataAttributeProcessor;
import org.jboss.metadata.ejb.parser.spec.MethodMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.UnexpectedAttributeProcessor;
import org.jboss.metadata.ejb.spec.ContainerTransactionMetaData;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodsMetaData;
import org.jboss.metadata.javaee.support.IdMetaData;

public class ContainerTransactionMetaDataParser
extends AbstractWithDescriptionsParser<ContainerTransactionMetaData> {
    private static final AttributeProcessor<IdMetaData> ATTRIBUTE_PROCESSOR = new IdMetaDataAttributeProcessor<Object>(UnexpectedAttributeProcessor.instance());
    public static final ContainerTransactionMetaDataParser INSTANCE = new ContainerTransactionMetaDataParser();

    @Override
    public ContainerTransactionMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        ContainerTransactionMetaData containerTransactionMetaData = new ContainerTransactionMetaData();
        AttributeProcessorHelper.processAttributes(containerTransactionMetaData, reader, ATTRIBUTE_PROCESSOR);
        this.processElements(containerTransactionMetaData, reader);
        return containerTransactionMetaData;
    }

    @Override
    protected void processElement(ContainerTransactionMetaData containerTransactionMetaData, XMLStreamReader reader) throws XMLStreamException {
        EjbJarElement ejbJarElement = EjbJarElement.forName(reader.getLocalName());
        switch (ejbJarElement) {
            case TRANS_ATTRIBUTE: {
                String txAttributeValue = ContainerTransactionMetaDataParser.getElementText((XMLStreamReader)reader);
                if (txAttributeValue == null || txAttributeValue.isEmpty()) {
                    throw ContainerTransactionMetaDataParser.unexpectedValue((XMLStreamReader)reader, (Throwable)new Exception("Unexpected null or empty value for trans-attribute"));
                }
                TransactionAttributeType txAttributeType = this.parseTxAttributeType(txAttributeValue);
                containerTransactionMetaData.setTransAttribute(txAttributeType);
                return;
            }
            case METHOD: {
                MethodsMetaData methods = containerTransactionMetaData.getMethods();
                if (methods == null) {
                    methods = new MethodsMetaData();
                    containerTransactionMetaData.setMethods(methods);
                }
                MethodMetaData method = MethodMetaDataParser.INSTANCE.parse(reader);
                methods.add(method);
                return;
            }
        }
        super.processElement(containerTransactionMetaData, reader);
    }

    private TransactionAttributeType parseTxAttributeType(String txAttrValue) {
        if (txAttrValue.equals("Required")) {
            return TransactionAttributeType.REQUIRED;
        }
        if (txAttrValue.equals("RequiresNew")) {
            return TransactionAttributeType.REQUIRES_NEW;
        }
        if (txAttrValue.equals("NotSupported")) {
            return TransactionAttributeType.NOT_SUPPORTED;
        }
        if (txAttrValue.equals("Supports")) {
            return TransactionAttributeType.SUPPORTS;
        }
        if (txAttrValue.equals("Mandatory")) {
            return TransactionAttributeType.MANDATORY;
        }
        if (txAttrValue.equals("Never")) {
            return TransactionAttributeType.NEVER;
        }
        throw new IllegalArgumentException("Unknown transaction attribute type value: " + txAttrValue);
    }
}

