/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.spec;

import java.util.Iterator;
import javax.ejb.TransactionManagementType;
import org.jboss.metadata.common.ejb.ITimeoutTarget;
import org.jboss.metadata.ejb.jboss.ejb3.JBossGenericBeanMetaData;
import org.jboss.metadata.ejb.spec.AbstractEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertiesMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;
import org.jboss.metadata.ejb.spec.EjbType;
import org.jboss.metadata.ejb.spec.MessageDrivenDestinationMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.SubscriptionDurability;
import org.jboss.metadata.javaee.support.MappableMetaData;

public class MessageDrivenBeanMetaData
extends AbstractEnterpriseBeanMetaData
implements ITimeoutTarget {
    private static final long serialVersionUID = -7353017099819838715L;
    private String messagingType;
    private NamedMethodMetaData timeoutMethod;
    private TransactionManagementType transactionType;
    private String messageDestinationType;
    private String messageDestinationLink;
    private ActivationConfigMetaData activationConfig;
    private AroundInvokesMetaData aroundInvokes;
    private String messageSelector;
    private String acknowledgeMode;
    private SubscriptionDurability subscriptionDurability;

    public MessageDrivenBeanMetaData() {
        this.setEjbType(EjbType.MESSAGE_DRIVEN);
    }

    @Override
    protected MessageDrivenBeanMetaData createMerged(AbstractEnterpriseBeanMetaData original) {
        MessageDrivenBeanMetaData merged = new MessageDrivenBeanMetaData();
        merged.merge(this, original);
        return merged;
    }

    public String getMessagingType() {
        return this.messagingType;
    }

    public boolean isJMS() {
        String messagingType = this.getMessagingType();
        return messagingType == null || "javax.jms.MessageListener".equals(messagingType);
    }

    public void setMessagingType(String messagingType) {
        if (messagingType == null) {
            throw new IllegalArgumentException("Null messagingType");
        }
        this.messagingType = messagingType;
    }

    @Override
    public NamedMethodMetaData getTimeoutMethod() {
        return this.timeoutMethod;
    }

    @Override
    public void setTimeoutMethod(NamedMethodMetaData timeoutMethod) {
        if (timeoutMethod == null) {
            throw new IllegalArgumentException("Null timeoutMethod");
        }
        this.timeoutMethod = timeoutMethod;
    }

    @Override
    public TransactionManagementType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(TransactionManagementType transactionType) {
        if (transactionType == null) {
            throw new IllegalArgumentException("Null transactionType");
        }
        this.transactionType = transactionType;
    }

    public String getMessageDestinationType() {
        return this.messageDestinationType;
    }

    public void setMessageDestinationType(String messageDestinationType) {
        if (messageDestinationType == null) {
            throw new IllegalArgumentException("Null messageDestinationType");
        }
        this.messageDestinationType = messageDestinationType;
    }

    public AroundInvokesMetaData getAroundInvokes() {
        return this.aroundInvokes;
    }

    public void setAroundInvokes(AroundInvokesMetaData aroundInvokes) {
        if (aroundInvokes == null) {
            throw new IllegalArgumentException("Null aroundInvokes");
        }
        this.aroundInvokes = aroundInvokes;
    }

    public String getMessageDestinationLink() {
        return this.messageDestinationLink;
    }

    public void setMessageDestinationLink(String messageDestinationLink) {
        if (messageDestinationLink == null) {
            throw new IllegalArgumentException("Null messageDestinationLink");
        }
        this.messageDestinationLink = messageDestinationLink;
    }

    public ActivationConfigMetaData getActivationConfig() {
        return this.activationConfig;
    }

    public void setActivationConfig(ActivationConfigMetaData activationConfig) {
        if (activationConfig == null) {
            throw new IllegalArgumentException("Null activationConfig");
        }
        this.activationConfig = activationConfig;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        if (messageSelector == null) {
            throw new IllegalArgumentException("Null messageSelector");
        }
        this.messageSelector = messageSelector;
    }

    public String getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(String acknowledgeMode) {
        if (acknowledgeMode == null) {
            throw new IllegalArgumentException("Null acknowledgeMode");
        }
        this.acknowledgeMode = acknowledgeMode;
    }

    public SubscriptionDurability getSubscriptionDurability() {
        return this.subscriptionDurability;
    }

    public void setSubscriptionDurability(SubscriptionDurability subscriptionDurability) {
        if (subscriptionDurability == null) {
            throw new IllegalArgumentException("Null subscriptionDurability");
        }
        this.subscriptionDurability = subscriptionDurability;
    }

    public void setMessageDrivenDestination(MessageDrivenDestinationMetaData mdd) {
        this.setMessageDestinationType(mdd.getDestinationType());
        String durability = mdd.getSubscriptionDurability();
        SubscriptionDurability sd = SubscriptionDurability.NonDurable;
        if (durability != null && durability.equalsIgnoreCase("Durable")) {
            sd = SubscriptionDurability.Durable;
        }
        this.setSubscriptionDurability(sd);
    }

    @Override
    public void merge(AbstractEnterpriseBeanMetaData override, AbstractEnterpriseBeanMetaData original) {
        this.merge((JBossGenericBeanMetaData)override, (MessageDrivenBeanMetaData)original);
    }

    public void merge(JBossGenericBeanMetaData override, MessageDrivenBeanMetaData original) {
        super.merge(override, original);
        if (override != null && override.getAcknowledgeMode() != null) {
            this.acknowledgeMode = override.getAcknowledgeMode();
        } else if (original != null) {
            this.acknowledgeMode = original.acknowledgeMode;
        }
        if (override != null && override.getActivationConfig() != null || original != null && original.activationConfig != null) {
            this.activationConfig = new ActivationConfigMetaData();
            this.activationConfig.merge(override != null ? override.getActivationConfig() : null, original != null ? original.activationConfig : null);
        }
        if (override != null && override.getDestinationJndiName() != null) {
            if (this.activationConfig == null) {
                this.activationConfig = new ActivationConfigMetaData();
            }
            ActivationConfigPropertyMetaData destination = null;
            if (this.activationConfig.getActivationConfigProperties() == null) {
                this.activationConfig.setActivationConfigProperties(new ActivationConfigPropertiesMetaData());
            }
            Iterator i$ = this.activationConfig.getActivationConfigProperties().iterator();
            while (i$.hasNext()) {
                ActivationConfigPropertyMetaData prop = (ActivationConfigPropertyMetaData)((Object)i$.next());
                if (!prop.getActivationConfigPropertyName().equals("destination")) continue;
                destination = prop;
                break;
            }
            if (destination == null) {
                destination = new ActivationConfigPropertyMetaData();
                destination.setActivationConfigPropertyName("destination");
                this.activationConfig.getActivationConfigProperties().add((MappableMetaData)destination);
            }
            destination.setValue(override.getDestinationJndiName());
        }
        if (override != null && override.getAroundInvokes() != null || original != null && original.aroundInvokes != null) {
            this.aroundInvokes = new AroundInvokesMetaData();
            this.aroundInvokes.merge(override != null ? override.getAroundInvokes() : null, original != null ? original.aroundInvokes : null);
        }
        if (override != null && override.getMessageDestinationLink() != null) {
            this.messageDestinationLink = override.getMessageDestinationLink();
        } else if (original != null) {
            this.messageDestinationLink = original.messageDestinationLink;
        }
        if (override != null && override.getMessageDestinationType() != null) {
            this.messageDestinationType = override.getMessageDestinationType();
        } else if (original != null) {
            this.messageDestinationType = original.messageDestinationType;
        }
        if (override != null && override.getMessageSelector() != null) {
            this.messageSelector = override.getMessageSelector();
        } else if (original != null) {
            this.messageSelector = original.messageSelector;
        }
        if (override != null && override.getMessagingType() != null) {
            this.messagingType = override.getMessagingType();
        } else if (original != null) {
            this.messagingType = original.messagingType;
        }
        if (override != null && override.getSubscriptionDurability() != null) {
            this.subscriptionDurability = override.getSubscriptionDurability();
        } else if (original != null) {
            this.subscriptionDurability = original.subscriptionDurability;
        }
        if (override != null && override.getTimeoutMethod() != null) {
            this.timeoutMethod = override.getTimeoutMethod();
        } else if (original != null) {
            this.timeoutMethod = original.timeoutMethod;
        }
        if (override != null && override.getTransactionType() != null) {
            this.transactionType = override.getTransactionType();
        } else if (original != null) {
            this.transactionType = original.transactionType;
        }
    }
}

