/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.spec;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.parser.spec.AbstractWithDescriptionsParser;
import org.jboss.metadata.ejb.parser.spec.AttributeProcessor;
import org.jboss.metadata.ejb.parser.spec.AttributeProcessorHelper;
import org.jboss.metadata.ejb.parser.spec.EjbJarAttribute;
import org.jboss.metadata.ejb.parser.spec.EjbJarElement;
import org.jboss.metadata.ejb.parser.spec.IdMetaDataAttributeProcessor;
import org.jboss.metadata.ejb.parser.spec.RelationRoleCmrFieldMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.RelationRoleSourceMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.UnexpectedAttributeProcessor;
import org.jboss.metadata.ejb.spec.MultiplicityType;
import org.jboss.metadata.ejb.spec.RelationRoleMetaData;
import org.jboss.metadata.javaee.spec.EmptyMetaData;
import org.jboss.metadata.javaee.support.IdMetaData;

public class RelationRoleMetaDataParser
extends AbstractWithDescriptionsParser<RelationRoleMetaData> {
    private static final AttributeProcessor<IdMetaData> ATTRIBUTE_PROCESSOR = new IdMetaDataAttributeProcessor<Object>(UnexpectedAttributeProcessor.instance());
    public static final RelationRoleMetaDataParser INSTANCE = new RelationRoleMetaDataParser();

    @Override
    public RelationRoleMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        RelationRoleMetaData data = new RelationRoleMetaData();
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            EjbJarAttribute ejbJarVersionAttribute;
            if (RelationRoleMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i) || (ejbJarVersionAttribute = EjbJarAttribute.forName(reader.getAttributeLocalName(i))) != EjbJarAttribute.ID) continue;
            data.setId(reader.getAttributeValue(i));
        }
        this.processElements(data, reader);
        return data;
    }

    @Override
    protected void processElement(RelationRoleMetaData relation, XMLStreamReader reader) throws XMLStreamException {
        EjbJarElement ejbJarElement = EjbJarElement.forName(reader.getLocalName());
        switch (ejbJarElement) {
            case EJB_RELATIONSHIP_ROLE_NAME: {
                relation.setEjbRelationshipRoleName(RelationRoleMetaDataParser.getElementText((XMLStreamReader)reader));
                return;
            }
            case MULTIPLICITY: {
                String text = RelationRoleMetaDataParser.getElementText((XMLStreamReader)reader);
                relation.setMultiplicity(MultiplicityType.valueOf(text));
                return;
            }
            case RELATIONSHIP_ROLE_SOURCE: {
                relation.setRoleSource(RelationRoleSourceMetaDataParser.INSTANCE.parse(reader));
                return;
            }
            case CMR_FIELD: {
                relation.setCmrField(RelationRoleCmrFieldMetaDataParser.INSTANCE.parse(reader));
                return;
            }
            case CASCADE_DELETE: {
                EmptyMetaData cascade = new EmptyMetaData();
                AttributeProcessorHelper.processAttributes(cascade, reader, ATTRIBUTE_PROCESSOR);
                relation.setCascadeDelete(cascade);
                reader.getElementText();
                return;
            }
        }
        super.processElement(relation, reader);
    }
}

