/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.spec;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.parser.spec.AbstractMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.EjbJarElement;
import org.jboss.metadata.ejb.spec.StatefulTimeoutMetaData;

public class StatefulTimeoutMetaDataParser
extends AbstractMetaDataParser<StatefulTimeoutMetaData> {
    public static final StatefulTimeoutMetaDataParser INSTANCE = new StatefulTimeoutMetaDataParser();
    private static final Map<String, TimeUnit> TIME_UNITS;

    @Override
    public StatefulTimeoutMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        StatefulTimeoutMetaData schedule = new StatefulTimeoutMetaData();
        this.processElements(schedule, reader);
        return schedule;
    }

    @Override
    protected void processElement(StatefulTimeoutMetaData schedule, XMLStreamReader reader) throws XMLStreamException {
        EjbJarElement ejbJarElement = EjbJarElement.forName(reader.getLocalName());
        switch (ejbJarElement) {
            case UNIT: {
                this.processUnitElement(schedule, reader);
                break;
            }
            case TIMEOUT: {
                this.processValueElement(schedule, reader);
                break;
            }
            default: {
                super.processElement(schedule, reader);
            }
        }
    }

    private void processValueElement(StatefulTimeoutMetaData schedule, XMLStreamReader reader) throws XMLStreamException {
        schedule.setTimeout(Long.valueOf(reader.getElementText()));
    }

    protected void processUnitElement(StatefulTimeoutMetaData metaData, XMLStreamReader reader) throws XMLStreamException {
        TimeUnit unit = TIME_UNITS.get(reader.getElementText());
        if (unit == null) {
            throw new RuntimeException("Cannot parse unit in <stateful-timeout> " + reader.getElementText());
        }
        metaData.setUnit(unit);
    }

    static {
        HashMap<String, TimeUnit> units = new HashMap<String, TimeUnit>();
        units.put("Days", TimeUnit.DAYS);
        units.put("Hours", TimeUnit.HOURS);
        units.put("Minutes", TimeUnit.MINUTES);
        units.put("Seconds", TimeUnit.SECONDS);
        units.put("Milliseconds", TimeUnit.MILLISECONDS);
        units.put("Microseconds", TimeUnit.MICROSECONDS);
        units.put("Nanoseconds", TimeUnit.NANOSECONDS);
        TIME_UNITS = Collections.unmodifiableMap(units);
    }
}

