/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jboss.util.Strings;

public class ReflectionUtils {
    public static Object invoke(Method method, Object target, Object[] arguments) throws Throwable {
        if (method == null) {
            throw new IllegalArgumentException("Null method");
        }
        try {
            return method.invoke(target, arguments);
        }
        catch (Throwable t) {
            throw ReflectionUtils.handleErrors(method.getName(), Strings.defaultToString((Object)target), method.getParameterTypes(), arguments, t);
        }
    }

    public static Object newInstance(Class clazz) throws Throwable {
        if (clazz == null) {
            throw new IllegalArgumentException("Null clazz");
        }
        try {
            return clazz.newInstance();
        }
        catch (Throwable t) {
            throw ReflectionUtils.handleErrors("new", clazz.getName(), null, null, t);
        }
    }

    public static Object newInstance(String className, ClassLoader cl) throws Throwable {
        if (className == null) {
            throw new IllegalArgumentException("Null class name");
        }
        if (cl == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        Class<?> clazz = cl.loadClass(className);
        try {
            return clazz.newInstance();
        }
        catch (Throwable t) {
            throw ReflectionUtils.handleErrors("new", clazz.getName(), null, null, t);
        }
    }

    public static Object newInstance(String className) throws Throwable {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return ReflectionUtils.newInstance(className, cl);
    }

    public static Object newInstance(Constructor constructor, Object[] arguments) throws Throwable {
        if (constructor == null) {
            throw new IllegalArgumentException("Null constructor");
        }
        try {
            return constructor.newInstance(arguments);
        }
        catch (Throwable t) {
            throw ReflectionUtils.handleErrors("new", constructor.getClass().getName(), constructor.getParameterTypes(), arguments, t);
        }
    }

    public static Object getField(Field field, Object target) throws Throwable {
        if (field == null) {
            throw new IllegalArgumentException("Null field");
        }
        try {
            return field.get(target);
        }
        catch (Throwable t) {
            throw ReflectionUtils.handleErrors("set", field, target, null, t);
        }
    }

    public static Object setField(Field field, Object target, Object value) throws Throwable {
        if (field == null) {
            throw new IllegalArgumentException("Null field");
        }
        try {
            field.set(target, value);
            return null;
        }
        catch (Throwable t) {
            throw ReflectionUtils.handleErrors("set", field, target, value, t);
        }
    }

    public static Throwable handleErrors(String context, Object target, Class[] parameters, Object[] arguments, Throwable t) throws Throwable {
        if (t instanceof IllegalArgumentException) {
            if (target == null) {
                throw new IllegalArgumentException("Null target for " + context);
            }
            ArrayList<String> expected = new ArrayList<String>();
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    expected.add(parameters[i].getName());
                }
            }
            ArrayList<String> actual = new ArrayList<String>();
            if (arguments != null) {
                for (int i = 0; i < arguments.length; ++i) {
                    if (arguments[i] == null) {
                        actual.add(null);
                        continue;
                    }
                    actual.add(arguments[i].getClass().getName());
                }
            }
            throw new IllegalArgumentException("Wrong arguments. " + context + " for target " + target + " expected=" + expected + " actual=" + actual);
        }
        if (t instanceof InvocationTargetException) {
            throw ((InvocationTargetException)t).getTargetException();
        }
        throw t;
    }

    public static Throwable handleErrors(String context, Field field, Object target, Object value, Throwable t) throws Throwable {
        if (t instanceof IllegalArgumentException) {
            String valueType = null;
            if (value != null) {
                valueType = value.getClass().getName();
            }
            throw new IllegalArgumentException("Error invoking field " + context + " for target " + target + " field " + field.getName() + " expected=" + field.getType().getName() + " actual=" + valueType);
        }
        throw t;
    }
}

