/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ScopeInfo;
import org.jboss.logging.Logger;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;

public class AbstractScopeInfo
implements ScopeInfo {
    private static final Logger log = Logger.getLogger(AbstractScopeInfo.class);
    private ScopeKey scopeKey;
    private ScopeKey mutableScopeKey;
    private ScopeKey installScope;
    private MutableMetaDataRepository repository;

    public AbstractScopeInfo(Object name) {
        this(name, null);
    }

    public AbstractScopeInfo(Object name, String className) {
        if (name == null) {
            throw new IllegalArgumentException("Null scope");
        }
        ScopeKey scopeKey = ScopeKey.DEFAULT_SCOPE.clone();
        scopeKey.addScope(CommonLevels.INSTANCE, (Object)name.toString());
        if (className != null) {
            scopeKey.addScope(CommonLevels.CLASS, (Object)className);
        }
        scopeKey.addScope(CommonLevels.WORK, (Object)String.valueOf(this.hashCode()));
        this.setScope(scopeKey);
        this.setMutableScope(new ScopeKey(CommonLevels.INSTANCE, (Object)name.toString()));
    }

    public AbstractScopeInfo(ScopeKey key, ScopeKey mutable) {
        this.setScope(key);
        this.setMutableScope(mutable);
    }

    public MetaData getMetaData() {
        if (this.repository == null) {
            return null;
        }
        return this.repository.getMetaData(this.getScope());
    }

    public void addMetaData(MutableMetaDataRepository repository, ControllerContext context) {
        this.repository = repository;
        ScopeKey scope = this.getMutableScope();
        MemoryMetaDataLoader mutable = new MemoryMetaDataLoader(scope);
        repository.addMetaDataRetrieval((MetaDataRetrieval)mutable);
        this.addMetaData(repository, context, mutable);
    }

    protected void addMetaData(MutableMetaDataRepository repository, ControllerContext context, MemoryMetaDataLoader mutable) {
    }

    public void removeMetaData(MutableMetaDataRepository repository, ControllerContext context) {
        ScopeKey scope;
        try {
            scope = this.getScope();
            repository.removeMetaDataRetrieval(scope);
        }
        catch (Exception e) {
            log.trace((Object)"Ignored", (Throwable)e);
        }
        try {
            scope = this.getMutableScope();
            repository.removeMetaDataRetrieval(scope);
        }
        catch (Exception e) {
            log.trace((Object)"Ignored", (Throwable)e);
        }
        this.repository = null;
    }

    public MetaDataRetrieval initMetaDataRetrieval(MutableMetaDataRepository repository, ControllerContext context, Scope scope) {
        return null;
    }

    public ScopeKey getScope() {
        return this.scopeKey;
    }

    public void setScope(ScopeKey key) {
        if (key == null) {
            throw new IllegalArgumentException("Null scope key");
        }
        this.scopeKey = key;
    }

    public ScopeKey getMutableScope() {
        return this.mutableScopeKey;
    }

    public void setMutableScope(ScopeKey key) {
        if (key == null) {
            throw new IllegalArgumentException("Null scope key");
        }
        this.mutableScopeKey = key;
    }

    public ScopeKey getInstallScope() {
        return this.installScope;
    }

    public void setInstallScope(ScopeKey key) {
        this.installScope = key;
    }
}

