/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly11.task.subsystem.elytron;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class MechanismProviderFilteringSaslServerFactoryAddOperation {
    private final PathAddress subsystemPathAddress;
    private final String mechanismProviderFilteringSaslServerFactory;
    private String saslServerFactory;
    private List<String> filters;

    public MechanismProviderFilteringSaslServerFactoryAddOperation(PathAddress subsystemPathAddress, String mechanismProviderFilteringSaslServerFactory) {
        this.subsystemPathAddress = subsystemPathAddress;
        this.mechanismProviderFilteringSaslServerFactory = mechanismProviderFilteringSaslServerFactory;
        this.filters = new ArrayList<String>();
    }

    public MechanismProviderFilteringSaslServerFactoryAddOperation saslServerFactory(String saslServerFactory) {
        this.saslServerFactory = saslServerFactory;
        return this;
    }

    public MechanismProviderFilteringSaslServerFactoryAddOperation addFilter(String filter) {
        this.filters.add(filter);
        return this;
    }

    public ModelNode toModelNode() {
        PathAddress pathAddress = this.subsystemPathAddress.append("mechanism-provider-filtering-sasl-server-factory", this.mechanismProviderFilteringSaslServerFactory);
        ModelNode operation = Util.createAddOperation((PathAddress)pathAddress);
        if (this.saslServerFactory != null) {
            operation.get("sasl-server-factory").set(this.saslServerFactory);
        }
        if (this.filters != null && !this.filters.isEmpty()) {
            ModelNode filtersNode = operation.get("filters").setEmptyList();
            for (String filter : this.filters) {
                filtersNode.add("provider-name", filter);
            }
        }
        return operation;
    }
}

