/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jboss.modules.AbstractResourceLoader;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.IterableResourceLoader;
import org.jboss.modules.JDKSpecific;
import org.jboss.modules.JarEntryResource;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.PathUtils;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoaders;
import org.jboss.modules.Utils;

final class JarFileResourceLoader
extends AbstractResourceLoader
implements IterableResourceLoader {
    private static final String INDEX_FILE = "META-INF/PATHS.LIST";
    private final JarFile jarFile;
    private final String rootName;
    private final URL rootUrl;
    private final String relativePath;
    private final File fileOfJar;
    private final Map<CodeSigners, CodeSource> codeSources = new HashMap<CodeSigners, CodeSource>();
    private static final CodeSigners EMPTY_CODE_SIGNERS = new CodeSigners(new CodeSigner[0]);

    JarFileResourceLoader(String rootName, JarFile jarFile) {
        this(rootName, jarFile, null);
    }

    JarFileResourceLoader(String rootName, JarFile jarFile, String relativePath) {
        String realPath;
        if (jarFile == null) {
            throw new IllegalArgumentException("jarFile is null");
        }
        if (rootName == null) {
            throw new IllegalArgumentException("rootName is null");
        }
        this.fileOfJar = new File(jarFile.getName());
        this.jarFile = jarFile;
        this.rootName = rootName;
        String string = realPath = relativePath == null ? null : PathUtils.canonicalize(relativePath);
        if (realPath != null && realPath.endsWith("/")) {
            realPath = realPath.substring(0, realPath.length() - 1);
        }
        this.relativePath = realPath;
        try {
            this.rootUrl = JarFileResourceLoader.getJarURI(this.fileOfJar.toURI(), realPath).toURL();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid root file specified", e);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid root file specified", e);
        }
    }

    private static URI getJarURI(URI original, String nestedPath) throws URISyntaxException {
        StringBuilder b = new StringBuilder();
        b.append("file:");
        assert (original.getScheme().equals("file"));
        String path = original.getPath();
        assert (path != null);
        String host = original.getHost();
        if (host != null) {
            String userInfo = original.getRawUserInfo();
            b.append("//");
            if (userInfo != null) {
                b.append(userInfo).append('@');
            }
            b.append(host);
        }
        b.append(path).append("!/");
        if (nestedPath != null) {
            b.append(nestedPath);
        }
        return new URI("jar", b.toString(), null);
    }

    @Override
    public String getRootName() {
        return this.rootName;
    }

    @Override
    public synchronized ClassSpec getClassSpec(String fileName) throws IOException {
        ClassSpec spec = new ClassSpec();
        JarEntry entry = this.getJarEntry(fileName);
        if (entry == null) {
            return null;
        }
        long size = entry.getSize();
        Throwable throwable = null;
        try (InputStream is = this.jarFile.getInputStream(entry);){
            if (size == -1L) {
                int res;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[16384];
                while ((res = is.read(buf)) > 0) {
                    baos.write(buf, 0, res);
                }
                CodeSource codeSource = this.createCodeSource(entry);
                baos.close();
                is.close();
                spec.setBytes(baos.toByteArray());
                spec.setCodeSource(codeSource);
                ClassSpec classSpec = spec;
                return classSpec;
            }
            if (size <= Integer.MAX_VALUE) {
                int res;
                int castSize = (int)size;
                byte[] bytes = new byte[castSize];
                int a = 0;
                while ((res = is.read(bytes, a, castSize - a)) > 0) {
                    a += res;
                }
                while (is.read() != -1) {
                }
                CodeSource codeSource = this.createCodeSource(entry);
                is.close();
                spec.setBytes(bytes);
                spec.setCodeSource(codeSource);
                ClassSpec classSpec = spec;
                return classSpec;
            }
            try {
                throw new IOException("Resource is too large to be a valid class file");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private CodeSource createCodeSource(JarEntry entry) {
        CodeSigner[] entryCodeSigners = entry.getCodeSigners();
        CodeSigners codeSigners = entryCodeSigners == null || entryCodeSigners.length == 0 ? EMPTY_CODE_SIGNERS : new CodeSigners(entryCodeSigners);
        CodeSource codeSource = this.codeSources.get(codeSigners);
        if (codeSource == null) {
            codeSource = new CodeSource(this.rootUrl, entryCodeSigners);
            this.codeSources.put(codeSigners, codeSource);
        }
        return codeSource;
    }

    private JarEntry getJarEntry(String fileName) {
        return this.relativePath == null ? this.jarFile.getJarEntry(fileName) : this.jarFile.getJarEntry(this.relativePath + "/" + fileName);
    }

    @Override
    public PackageSpec getPackageSpec(String name) throws IOException {
        Manifest manifest;
        if (this.relativePath == null) {
            manifest = this.jarFile.getManifest();
        } else {
            JarEntry jarEntry = this.getJarEntry("META-INF/MANIFEST.MF");
            if (jarEntry == null) {
                manifest = null;
            } else {
                try (InputStream inputStream = this.jarFile.getInputStream(jarEntry);){
                    manifest = new Manifest(inputStream);
                }
            }
        }
        return JarFileResourceLoader.getPackageSpec(name, manifest, this.rootUrl);
    }

    @Override
    public String getLibrary(String name) {
        return null;
    }

    @Override
    public Resource getResource(String name) {
        try {
            URI uri;
            JarFile jarFile = this.jarFile;
            name = PathUtils.canonicalize(PathUtils.relativize(name));
            JarEntry entry = this.getJarEntry(name);
            if (entry == null) {
                return null;
            }
            try {
                File absoluteFile = new File(jarFile.getName()).getAbsoluteFile();
                String path = absoluteFile.getPath();
                path = PathUtils.canonicalize(path);
                if (File.separatorChar != '/') {
                    path = path.replace(File.separatorChar, '/');
                }
                if (PathUtils.isRelative(path)) {
                    path = "/" + path;
                }
                if (path.startsWith("//")) {
                    path = "//" + path;
                }
                uri = new URI("file", null, path, null);
            }
            catch (URISyntaxException x) {
                throw new IllegalStateException(x);
            }
            return new JarEntryResource(jarFile, entry, this.relativePath, new URL(null, JarFileResourceLoader.getJarURI(uri, entry.getName()).toString(), (URLStreamHandler)null));
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public Iterator<Resource> iterateResources(String startPath, final boolean recursive) {
        final JarFile jarFile = this.jarFile;
        if (this.relativePath != null) {
            startPath = startPath.equals("") ? this.relativePath : this.relativePath + "/" + startPath;
        }
        final String startName = PathUtils.canonicalize(PathUtils.relativize(startPath));
        final Enumeration<JarEntry> entries = jarFile.entries();
        return new Iterator<Resource>(){
            private Resource next;

            @Override
            public boolean hasNext() {
                while (this.next == null) {
                    if (!entries.hasMoreElements()) {
                        return false;
                    }
                    JarEntry entry = (JarEntry)entries.nextElement();
                    String name = entry.getName();
                    if (!(recursive ? PathUtils.isChild(startName, name) : PathUtils.isDirectChild(startName, name)) || entry.isDirectory()) continue;
                    try {
                        this.next = new JarEntryResource(jarFile, entry, JarFileResourceLoader.this.relativePath, JarFileResourceLoader.getJarURI(new File(jarFile.getName()).toURI(), entry.getName()).toURL());
                    }
                    catch (Exception exception) {}
                }
                return true;
            }

            @Override
            public Resource next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    Resource resource = this.next;
                    return resource;
                }
                finally {
                    this.next = null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Collection<String> getPaths() {
        JarEntry listEntry;
        long indexModified;
        HashSet<String> index = new HashSet<String>();
        index.add("");
        String relativePath = this.relativePath;
        JarFile jarFile = this.jarFile;
        String jarFileName = jarFile.getName();
        long jarModified = this.fileOfJar.lastModified();
        File indexFile = new File(jarFileName + ".index");
        if (ResourceLoaders.USE_INDEXES && indexFile.exists() && (indexModified = indexFile.lastModified()) != 0L && jarModified != 0L && indexModified >= jarModified) {
            try {
                return JarFileResourceLoader.readIndex(new FileInputStream(indexFile), index, relativePath);
            }
            catch (IOException e) {
                index.clear();
            }
        }
        if ((listEntry = jarFile.getJarEntry(INDEX_FILE)) != null) {
            try {
                return JarFileResourceLoader.readIndex(jarFile.getInputStream(listEntry), index, relativePath);
            }
            catch (IOException e) {
                index.clear();
            }
        }
        JarFileResourceLoader.extractJarPaths(jarFile, relativePath, index);
        if (ResourceLoaders.WRITE_INDEXES && relativePath == null) {
            JarFileResourceLoader.writeExternalIndex(indexFile, index);
        }
        return index;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            try {
                this.jarFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public URI getLocation() {
        try {
            return JarFileResourceLoader.getJarURI(this.fileOfJar.toURI(), "");
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    static void extractJarPaths(JarFile jarFile, String relativePath, Collection<String> index) {
        index.add("");
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String path;
            JarEntry jarEntry = entries.nextElement();
            String name = jarEntry.getName();
            int idx = name.lastIndexOf(47);
            if (idx == -1 || (path = name.substring(0, idx)).length() == 0 || path.endsWith("/")) continue;
            if (relativePath == null) {
                index.add(path);
                continue;
            }
            if (!path.startsWith(relativePath + "/")) continue;
            index.add(path.substring(relativePath.length() + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeExternalIndex(File indexFile, Collection<String> index) {
        boolean ok = false;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(indexFile)));){
            for (String name : index) {
                writer.write(name);
                writer.write(10);
            }
            writer.close();
            ok = true;
        }
        catch (IOException iOException) {
        }
        finally {
            if (!ok) {
                indexFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Collection<String> readIndex(InputStream stream, Collection<String> index, String relativePath) throws IOException {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(stream));){
            String s;
            while ((s = r.readLine()) != null) {
                String name = s.trim();
                if (relativePath == null) {
                    index.add(name);
                    continue;
                }
                if (!name.startsWith(relativePath + "/")) continue;
                index.add(name.substring(relativePath.length() + 1));
            }
            Collection<String> collection = index;
            return collection;
        }
    }

    static void addInternalIndex(File file, boolean modify) throws IOException {
        try (JarFile oldJarFile = JDKSpecific.getJarFile(file, false);){
            TreeSet<String> index = new TreeSet<String>();
            File outputFile = new File(file.getAbsolutePath().replace(".jar", "-indexed.jar"));
            try (ZipOutputStream zo = new ZipOutputStream(new FileOutputStream(outputFile));){
                Enumeration<JarEntry> entries = oldJarFile.entries();
                while (entries.hasMoreElements()) {
                    String path;
                    String name;
                    int idx;
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().equals(INDEX_FILE)) {
                        JarEntry clone = (JarEntry)entry.clone();
                        if (clone.getMethod() != 0) {
                            clone.setCompressedSize(-1L);
                        }
                        zo.putNextEntry(clone);
                        Utils.copy(oldJarFile.getInputStream(entry), zo);
                    }
                    if ((idx = (name = entry.getName()).lastIndexOf(47)) == -1 || (path = name.substring(0, idx)).length() == 0 || path.endsWith("/")) continue;
                    index.add(path);
                }
                zo.putNextEntry(new ZipEntry(INDEX_FILE));
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(zo));){
                    for (String name : index) {
                        writer.write(name);
                        writer.write(10);
                    }
                }
                zo.close();
                oldJarFile.close();
                if (modify) {
                    file.delete();
                    if (!outputFile.renameTo(file)) {
                        throw new IOException("failed to rename " + outputFile.getAbsolutePath() + " to " + file.getAbsolutePath());
                    }
                }
            }
        }
    }

    static final class CodeSigners {
        private final CodeSigner[] codeSigners;
        private final int hashCode;

        CodeSigners(CodeSigner[] codeSigners) {
            this.codeSigners = codeSigners;
            this.hashCode = Arrays.hashCode(codeSigners);
        }

        public boolean equals(Object obj) {
            return obj instanceof CodeSigners && this.equals((CodeSigners)obj);
        }

        private boolean equals(CodeSigners other) {
            return Arrays.equals(this.codeSigners, other.codeSigners);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

