/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.value;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

public final class ConstructedValue<T>
implements Value<T> {
    private final Constructor<T> constructor;
    private final List<? extends Value<?>> parameters;

    public ConstructedValue(Constructor<T> constructor, List<? extends Value<?>> parameters) {
        if (constructor == null) {
            throw new IllegalArgumentException("constructor is null");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("parameters is null");
        }
        this.constructor = constructor;
        this.parameters = parameters;
    }

    @Override
    public T getValue() throws IllegalStateException {
        try {
            return this.constructor.newInstance(Values.getValues(this.parameters));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Field is not accessible", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Failed to invoke constructor", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Failed to construct instance", e);
        }
    }
}

