/*
* JBoss, Home of Professional Open Source
* Copyright 2009, Red Hat Middleware LLC, and individual contributors
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.jmx.mbeanserver;

import java.io.ObjectInputStream;
import java.util.Set;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

/**
 * DelegateMBeanServer.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public abstract class DelegateMBeanServer implements MBeanServer
{
   /** The next MBeaNServer */
   private MBeanServer next; 

   /** The delegate state */
   private DelegateState state;
   
   public DelegateMBeanServer(DelegateState state)
   {
      if (state == null)
         throw new IllegalArgumentException("Null state");
      this.state = state;
   }

   /**
    * Get the next.
    * 
    * @return the next
    */
   protected MBeanServer getNext()
   {
      return next;
   }

   /**
    * Set the next.
    * 
    * @param next the next.
    */
   protected void setNext(MBeanServer next)
   {
      this.next = next;
   }

   /**
    * Get the outer.
    * 
    * @return the outer.
    */
   protected MBeanServer getOuter()
   {
      return getState().getOuter();
   }

   /**
    * Get the delegate.
    * 
    * @return the delegate.
    */
   protected MBeanServerDelegate getDelegate()
   {
      return getState().getDelegate();
   }

   /**
    * Get the state.
    * 
    * @return the state.
    */
   protected DelegateState getState()
   {
      return state;
   }

   public String getDefaultDomain()
   {
      return getNext().getDefaultDomain();
   }

   public String[] getDomains()
   {
      return getNext().getDomains();
   }

   public Integer getMBeanCount()
   {
      return getNext().getMBeanCount();
   }

   public MBeanInfo getMBeanInfo(ObjectName name) 
      throws InstanceNotFoundException, 
             IntrospectionException,
             ReflectionException
   {
      return getNext().getMBeanInfo(name);
   }

   public Object getAttribute(ObjectName name, String attribute) 
      throws MBeanException, 
             AttributeNotFoundException,
             InstanceNotFoundException, 
             ReflectionException
   {
      return getNext().getAttribute(name, attribute);
   }

   public AttributeList getAttributes(ObjectName name, String[] attributes) 
      throws InstanceNotFoundException,
             ReflectionException
   {
      return getNext().getAttributes(name, attributes);
   }

   public void setAttribute(ObjectName name, Attribute attribute) 
      throws InstanceNotFoundException,
             AttributeNotFoundException, 
             InvalidAttributeValueException, 
             MBeanException, 
             ReflectionException
   {
      getNext().setAttribute(name, attribute);
   }

   public AttributeList setAttributes(ObjectName name, AttributeList attributes) 
      throws InstanceNotFoundException,
             ReflectionException
   {
      return getNext().setAttributes(name, attributes);
   }

   public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature)
         throws InstanceNotFoundException, 
                MBeanException, 
                ReflectionException
   {
      return getNext().invoke(name, operationName, params, signature);
   }

   public ObjectInstance registerMBean(Object object, ObjectName name) 
      throws InstanceAlreadyExistsException,
             MBeanRegistrationException, 
             NotCompliantMBeanException
   {
      return getNext().registerMBean(object, name);
   }

   public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException
   {
      getNext().unregisterMBean(name);
   }

   public ObjectInstance createMBean(String className, 
                                     ObjectName name, 
                                     Object[] params, 
                                     String[] signature)
      throws ReflectionException, 
             InstanceAlreadyExistsException, 
             MBeanRegistrationException, 
             MBeanException,
             NotCompliantMBeanException
   {
      return getNext().createMBean(className, name, params, signature);
   }

   public ObjectInstance createMBean(String className, 
                                     ObjectName name, 
                                     ObjectName loaderName, 
                                     Object[] params,
                                     String[] signature) 
      throws ReflectionException, 
             InstanceAlreadyExistsException, 
             MBeanRegistrationException,
             MBeanException, 
             NotCompliantMBeanException, 
             InstanceNotFoundException
   {
      return getNext().createMBean(className, name, loaderName, params, signature);
   }

   public ObjectInstance createMBean(String className, 
                                     ObjectName name, 
                                     ObjectName loaderName)
      throws ReflectionException, 
             InstanceAlreadyExistsException, 
             MBeanRegistrationException, 
             MBeanException,
             NotCompliantMBeanException, 
             InstanceNotFoundException
   {
      return getNext().createMBean(className, name, loaderName);
   }

   public ObjectInstance createMBean(String className, ObjectName name) 
      throws ReflectionException,
             InstanceAlreadyExistsException, 
             MBeanRegistrationException, 
             MBeanException, 
             NotCompliantMBeanException
   {
      return getNext().createMBean(className, name);
   }

   public Object instantiate(String className, Object[] params, String[] signature) 
      throws ReflectionException,
             MBeanException
   {
      return getNext().instantiate(className, params, signature);
   }

   public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature)
      throws ReflectionException, 
             MBeanException, 
             InstanceNotFoundException
   {
      return getNext().instantiate(className, loaderName, params, signature);
   }

   public Object instantiate(String className, ObjectName loaderName) 
      throws ReflectionException, 
             MBeanException,
             InstanceNotFoundException
   {
      return getNext().instantiate(className, loaderName);
   }

   public Object instantiate(String className) throws ReflectionException, MBeanException
   {
      return getNext().instantiate(className);
   }

   public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException
   {
      return getNext().getObjectInstance(name);
   }

   public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException
   {
      return getNext().isInstanceOf(name, className);
   }

   public boolean isRegistered(ObjectName name)
   {
      return getNext().isRegistered(name);
   }

   @SuppressWarnings("unchecked")
   public Set queryMBeans(ObjectName name, QueryExp query)
   {
      return getNext().queryMBeans(name, query);
   }

   @SuppressWarnings("unchecked")
   public Set queryNames(ObjectName name, QueryExp query)
   {
      return getNext().queryNames(name, query);
   }

   public void addNotificationListener(ObjectName name, 
                                       NotificationListener listener, 
                                       NotificationFilter filter,
                                       Object handback) 
      throws InstanceNotFoundException
   {
      getNext().addNotificationListener(name, listener, filter, handback);
   }

   public void addNotificationListener(ObjectName name, 
                                       ObjectName listener, 
                                       NotificationFilter filter, 
                                       Object handback)
      throws InstanceNotFoundException
   {
      getNext().addNotificationListener(name, listener, filter, handback);
   }

   public void removeNotificationListener(ObjectName name, 
                                          NotificationListener listener, 
                                          NotificationFilter filter,
                                          Object handback) 
      throws InstanceNotFoundException, 
             ListenerNotFoundException
   {
      getNext().removeNotificationListener(name, listener, filter, handback);
   }

   public void removeNotificationListener(ObjectName name, NotificationListener listener)
      throws InstanceNotFoundException, 
             ListenerNotFoundException
   {
      getNext().removeNotificationListener(name, listener);
   }

   public void removeNotificationListener(ObjectName name, 
                                          ObjectName listener, 
                                          NotificationFilter filter,
                                          Object handback) 
      throws InstanceNotFoundException, 
             ListenerNotFoundException
   {
      getNext().removeNotificationListener(name, listener, filter, handback);
   }

   public void removeNotificationListener(ObjectName name, ObjectName listener) 
      throws InstanceNotFoundException,
             ListenerNotFoundException
   {
      getNext().removeNotificationListener(name, listener);
   }

   public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException
   {
      return getNext().getClassLoader(loaderName);
   }

   public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException
   {
      return getNext().getClassLoaderFor(mbeanName);
   }

   public ClassLoaderRepository getClassLoaderRepository()
   {
      return getNext().getClassLoaderRepository();
   }

   @Deprecated
   public ObjectInputStream deserialize(ObjectName name, byte[] data) 
      throws InstanceNotFoundException,
             OperationsException
   {
      return getNext().deserialize(name, data);
   }

   @Deprecated
   public ObjectInputStream deserialize(String className, byte[] data) 
      throws OperationsException, 
             ReflectionException
   {
      return getNext().deserialize(className, data);
   }

   @Deprecated
   public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data)
         throws InstanceNotFoundException, 
                OperationsException, 
                ReflectionException
   {
      return getNext().deserialize(className, loaderName, data);
   }
}
