/*
* JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.jmx.mbeanserver;

import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;

/**
 * PlainMBeanServerBuilder.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public class JBossMBeanServerBuilder extends MBeanServerBuilder
{
   /** The system property for the builder */
   public final static String MBEAN_SERVER_BUILDER_CLASS_PROPERTY = "javax.management.builder.initial";
   
   /**
    * Construct an MBeanServerBuilder
    */
   public JBossMBeanServerBuilder()
   {
   }

   /**
    * Construct an MBeanServer.
    *
    * @param defaultDomain the default domain when an MBean is
    *        registered with an ObjectName without a domain.
    * @param outer the wrapping MBeanServer, passed to MBeans
    *        at registration.
    * @param delegate the delegate to use for Notifications.
    */
   public MBeanServer newMBeanServer(String defaultDomain,
                                     MBeanServer outer,
                                     MBeanServerDelegate delegate)
   {
      try
      {
         DelegateState state = new DelegateState(outer, delegate);
         MBeanServerChain chain = new MBeanServerChain(state);
         JBossMBeanServer result = new JBossMBeanServer(state);
         
         MBeanServer server = super.newMBeanServer(defaultDomain, result, delegate);
         chain.setTarget(server);
         
         chain.addLast(result);
         return result;
      }
      catch (RuntimeException e)
      {
         e.printStackTrace();
         throw e;
      }
   }

   /**
    * Construct an MBeanServerDelegate.
    */
   public MBeanServerDelegate newMBeanServerDelegate()
   {
      return new MBeanServerDelegate();
   }
}
