/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jdbc;

import com.arjuna.ats.internal.jdbc.ConnectionManager;
import com.arjuna.ats.jdbc.logging.jdbcLogger;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class TransactionalDriver
implements Driver {
    public static final String arjunaDriver = "jdbc:arjuna:";
    public static final String jdbc = "jdbc:";
    public static final String userName = "user";
    public static final String password = "password";
    public static final String dynamicClass = "DYNAMIC_CLASS";
    public static final String createDb = "CREATE_DB";
    public static final String poolConnections = "POOL_CONNECTIONS";

    public TransactionalDriver() {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)"TransactionalDriver.TransactionalDriver ()");
        }
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)("TransactionalDriver.connect ( " + url + " )"));
        }
        if (!url.startsWith(arjunaDriver)) {
            return null;
        }
        return ConnectionManager.create(url.substring(arjunaDriver.length()), info);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)("TransactionalDriver.acceptsURL ( " + url + " )"));
        }
        if (url != null) {
            return url.indexOf(arjunaDriver) != -1;
        }
        return false;
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        int index;
        if (jdbcLogger.logger.isTraceEnabled()) {
            jdbcLogger.logger.trace((Object)("TransactionalDriver.getPropertyInfo ( " + url + " )"));
        }
        if ((index = url.indexOf(arjunaDriver)) == -1) {
            return null;
        }
        String theUrl = url.substring(index + arjunaDriver.length());
        Driver d = DriverManager.getDriver(theUrl);
        if (d != null) {
            return d.getPropertyInfo(theUrl, info);
        }
        return null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new TransactionalDriver());
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

