/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.cdi;

import com.arjuna.ats.jta.cdi.AbstractBean;
import com.arjuna.ats.jta.cdi.JNDIBean;
import com.arjuna.ats.jta.cdi.TransactionContext;
import com.arjuna.ats.jta.cdi.transactional.TransactionalInterceptorMandatory;
import com.arjuna.ats.jta.cdi.transactional.TransactionalInterceptorNever;
import com.arjuna.ats.jta.cdi.transactional.TransactionalInterceptorNotSupported;
import com.arjuna.ats.jta.cdi.transactional.TransactionalInterceptorRequired;
import com.arjuna.ats.jta.cdi.transactional.TransactionalInterceptorRequiresNew;
import com.arjuna.ats.jta.cdi.transactional.TransactionalInterceptorSupports;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.inject.Singleton;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionScoped;
import javax.transaction.TransactionSynchronizationRegistry;

public class TransactionExtension
implements Extension {
    public static final String TX_INTERCEPTOR = "-tx-interceptor";
    private Map<Bean<?>, AnnotatedType<?>> beanToAnnotatedTypeMapping = new HashMap();

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager manager) {
        boolean maybeAddInitialContextBean = false;
        Set beans = manager.getBeans(TransactionManager.class, new Annotation[0]);
        if (beans.isEmpty()) {
            event.addBean(new JNDIBean<TransactionManager>(jtaPropertyManager.getJTAEnvironmentBean().getTransactionManagerJNDIContext(), TransactionManager.class));
            maybeAddInitialContextBean = true;
        }
        if ((beans = manager.getBeans(TransactionSynchronizationRegistry.class, new Annotation[0])).isEmpty()) {
            event.addBean(new JNDIBean<TransactionSynchronizationRegistry>(jtaPropertyManager.getJTAEnvironmentBean().getTransactionSynchronizationRegistryJNDIContext(), TransactionSynchronizationRegistry.class));
            maybeAddInitialContextBean = true;
        }
        if (maybeAddInitialContextBean && (beans = manager.getBeans(InitialContext.class, new Annotation[0])).isEmpty()) {
            event.addBean((Bean)new AbstractBean<InitialContext>(){

                public final Set<Type> getTypes() {
                    return Collections.singleton(InitialContext.class);
                }

                @Override
                public final Class<? extends Annotation> getScope() {
                    return Singleton.class;
                }

                public final InitialContext create(CreationalContext<InitialContext> cc) {
                    try {
                        return new InitialContext();
                    }
                    catch (NamingException namingException) {
                        throw new CreationException(namingException.getMessage(), (Throwable)namingException);
                    }
                }

                @Override
                public final void destroy(InitialContext context, CreationalContext<InitialContext> cc) {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (NamingException namingException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        event.addContext((Context)new TransactionContext(() -> {
            Bean tmBean = manager.resolve(manager.getBeans(TransactionManager.class, new Annotation[0]));
            return (TransactionManager)manager.getReference(tmBean, TransactionManager.class, manager.createCreationalContext((Contextual)tmBean));
        }, () -> {
            Bean tsrBean = manager.resolve(manager.getBeans(TransactionSynchronizationRegistry.class, new Annotation[0]));
            return (TransactionSynchronizationRegistry)manager.getReference(tsrBean, TransactionSynchronizationRegistry.class, manager.createCreationalContext((Contextual)tsrBean));
        }));
    }

    public void register(@Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        bbd.addScope(TransactionScoped.class, true, true);
        bbd.addAnnotatedType(bm.createAnnotatedType(TransactionalInterceptorMandatory.class), TransactionalInterceptorMandatory.class.getName() + TX_INTERCEPTOR);
        bbd.addAnnotatedType(bm.createAnnotatedType(TransactionalInterceptorNever.class), TransactionalInterceptorNever.class.getName() + TX_INTERCEPTOR);
        bbd.addAnnotatedType(bm.createAnnotatedType(TransactionalInterceptorNotSupported.class), TransactionalInterceptorNotSupported.class.getName() + TX_INTERCEPTOR);
        bbd.addAnnotatedType(bm.createAnnotatedType(TransactionalInterceptorRequired.class), TransactionalInterceptorRequired.class.getName() + TX_INTERCEPTOR);
        bbd.addAnnotatedType(bm.createAnnotatedType(TransactionalInterceptorRequiresNew.class), TransactionalInterceptorRequiresNew.class.getName() + TX_INTERCEPTOR);
        bbd.addAnnotatedType(bm.createAnnotatedType(TransactionalInterceptorSupports.class), TransactionalInterceptorSupports.class.getName() + TX_INTERCEPTOR);
    }

    public void processManagedBean(@Observes ProcessManagedBean<?> pmb) {
        this.beanToAnnotatedTypeMapping.put(pmb.getBean(), pmb.getAnnotatedBeanClass());
    }

    public Map<Bean<?>, AnnotatedType<?>> getBeanToAnnotatedTypeMapping() {
        return this.beanToAnnotatedTypeMapping;
    }
}

