/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.metadata;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class CaseInsensitiveDictionary
extends Hashtable {
    private static final long serialVersionUID = 5802491129524016545L;
    private Dictionary<String, Object> delegate;
    private Set<String> originalKeys;

    public CaseInsensitiveDictionary(Dictionary delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegaqte");
        }
        this.delegate = new Hashtable<String, Object>(delegate.size());
        this.originalKeys = Collections.synchronizedSet(new HashSet());
        Enumeration e = delegate.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (this.get(key) != null) {
                throw new IllegalArgumentException("Properties contain duplicates with varying case for key=" + key + " : " + delegate);
            }
            this.delegate.put(key.toLowerCase(), delegate.get(key));
            this.originalKeys.add(key);
        }
    }

    @Override
    public Enumeration<Object> elements() {
        return this.delegate.elements();
    }

    @Override
    public synchronized boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Dictionary)) {
            return false;
        }
        Dictionary other = (Dictionary)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        for (String key : this.originalKeys) {
            if (!this.get(key).equals(other.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String) {
            key = ((String)key).toLowerCase();
        }
        return this.delegate.get(key);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Enumeration<String> keys() {
        return new Vector<String>(this.originalKeys).elements();
    }

    @Override
    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException("immutable");
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("immutable");
    }

    @Override
    public Set keySet() {
        return this.originalKeys;
    }

    @Override
    public Set entrySet() {
        HashSet<1> entrySet = new HashSet<1>();
        for (final String key : this.originalKeys) {
            final Object value = this.get(key);
            Map.Entry entry = new Map.Entry(){

                public Object getKey() {
                    return key;
                }

                public Object getValue() {
                    return value;
                }

                public Object setValue(Object value2) {
                    throw new UnsupportedOperationException("immutable");
                }
            };
            entrySet.add(entry);
        }
        return entrySet;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

