/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.web.impl;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.jboss.portal.common.net.media.MediaType;
import org.jboss.portal.web.Body;
import org.jboss.portal.web.IllegalRequestException;
import org.jboss.portal.web.WebRequest;
import org.jboss.portal.web.util.RequestDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWebRequest
extends HttpServletRequestWrapper
implements WebRequest {
    public static final MediaType APPLICATION_X_WWW_FORM_URLENCODED_MEDIA_TYPE = MediaType.APPLICATION_X_WWW_FORM_URLENCODED;
    public static final MediaType MULTIPART_FORM_DATA_MEDIA_TYPE = MediaType.create((String)"multipart/form-data");
    public static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    private final Map<String, String[]> queryParameterMap;
    private final Body body;
    private final WebRequest.Verb verb;
    private final MediaType mediaType;

    public AbstractWebRequest(HttpServletRequest req) throws UnsupportedEncodingException, IllegalRequestException {
        super(req);
        WebRequest.Verb verb;
        if ("GET".equals(req.getMethod())) {
            verb = WebRequest.Verb.GET;
        } else if ("POST".equals(req.getMethod())) {
            verb = WebRequest.Verb.POST;
        } else {
            throw new IllegalRequestException("HTTP Method " + req.getMethod() + " not accepted");
        }
        RequestDecoder decoder = new RequestDecoder(req);
        this.verb = verb;
        this.queryParameterMap = decoder.getQueryParameters();
        this.body = decoder.getBody();
        this.mediaType = decoder.getMediaType();
    }

    @Override
    public WebRequest.Verb getVerb() {
        return this.verb;
    }

    @Override
    public Map<String, String[]> getQueryParameterMap() {
        return this.queryParameterMap;
    }

    @Override
    public Body getBody() {
        return this.body;
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getQueryParameter(String parameterName) {
        String[] values = this.getQueryParameterValues(parameterName);
        return values != null ? values[0] : null;
    }

    @Override
    public String[] getQueryParameterValues(String parameterName) {
        if (parameterName == null) {
            throw new IllegalArgumentException();
        }
        return this.queryParameterMap.get(parameterName);
    }

    @Override
    public String getBodyParameter(String parameterName) {
        String[] values = this.getBodyParameterValues(parameterName);
        return values != null ? values[0] : null;
    }

    @Override
    public String[] getBodyParameterValues(String parameterName) {
        if (parameterName == null) {
            throw new IllegalArgumentException();
        }
        return this.body instanceof Body.Form ? ((Body.Form)this.body).getParameters().get(parameterName) : null;
    }
}

