/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.application;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.ActionRequest;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.PortletSessionUtil;
import javax.portlet.RenderRequest;
import javax.portlet.faces.BridgeException;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portletbridge.application.PortletViewState;

public class PortletStateHolder {
    public static final String STATE_HOLDER = PortletStateHolder.class.getName();
    private static final String DEFAULT = "default-";
    private static final Log log = LogFactory.getLog(PortletStateHolder.class);
    private PortletMode lastMode = PortletMode.VIEW;
    public static final String WINDOW_ID_RETRIVER = "org.jboss.portletbridge.WINDOW_ID_RETRIVER";
    public static final String STATE_ID_PARAMETER = "javax.faces.portletbridge.STATE_ID";
    private static final int DEFAULT_MAX_MANAGED_SCOPES = 1000;
    private final Map<String, PortletViewState> states;

    private PortletStateHolder(int max) {
        this.states = new LRUMap<String, PortletViewState>(max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PortletStateHolder init(PortletContext context) {
        PortletStateHolder stateHolder;
        PortletContext portletContext = context;
        synchronized (portletContext) {
            stateHolder = (PortletStateHolder)context.getAttribute(STATE_HOLDER);
            if (null == stateHolder) {
                int maxScopes = 1000;
                String maxScopesParameter = context.getInitParameter("javax.portlet.faces.MAX_MANAGED_REQUEST_SCOPES");
                if (null != maxScopesParameter) {
                    maxScopes = Integer.parseInt(maxScopesParameter);
                }
                stateHolder = new PortletStateHolder(maxScopes);
                context.setAttribute(STATE_HOLDER, (Object)stateHolder);
            }
        }
        return stateHolder;
    }

    public static PortletStateHolder getInstance(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        PortletStateHolder stateHolder = (PortletStateHolder)externalContext.getApplicationMap().get(STATE_HOLDER);
        if (null == stateHolder) {
            throw new BridgeException("Jsf portletbridge bridge not initialized");
        }
        return stateHolder;
    }

    public void addWindowState(String stateId, PortletViewState state) {
        this.states.put(stateId, state);
    }

    public PortletViewState getWindowState(String stateId) {
        PortletViewState state = null;
        if (null != stateId) {
            state = this.states.get(stateId);
        }
        return state;
    }

    public String getStateId(String portletName, ActionRequest actionRequest) {
        UUID uuid = UUID.randomUUID();
        String portletModeName = actionRequest.getPortletMode().toString();
        String stateId = this.getScopeId(portletName, (PortletRequest)actionRequest) + portletModeName + ":" + uuid.toString();
        return stateId;
    }

    public String getStateId(String portletName, String namespace, RenderRequest renderRequest) {
        String portletModeName = renderRequest.getPortletMode().toString();
        String scopeId = this.getScopeId(portletName, (PortletRequest)renderRequest);
        String stateId = renderRequest.getParameter(STATE_ID_PARAMETER);
        if (null == stateId) {
            stateId = scopeId + portletModeName + ":" + namespace;
        } else {
            int modeEnd = stateId.indexOf(58, scopeId.length());
            String oldModeName = stateId.substring(scopeId.length(), modeEnd);
            if (!portletModeName.equals(oldModeName)) {
                stateId = scopeId + portletModeName + stateId.substring(modeEnd);
            }
        }
        return stateId;
    }

    public synchronized String getScopeId(String portletName, PortletRequest request) {
        PortletSession portletSession = request.getPortletSession(true);
        String scopeId = portletName + portletSession.getId() + ":";
        WindowIDRetriver idRetriver = (WindowIDRetriver)portletSession.getAttribute(WINDOW_ID_RETRIVER);
        if (null == idRetriver) {
            idRetriver = new WindowIDRetriver(scopeId);
            portletSession.setAttribute(WINDOW_ID_RETRIVER, (Object)idRetriver);
        }
        return scopeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSessionStates(String scoprId) {
        Map<String, PortletViewState> map = this.states;
        synchronized (map) {
            Iterator<String> keysIterator = this.states.keySet().iterator();
            while (keysIterator.hasNext()) {
                String key = keysIterator.next();
                if (!key.startsWith(scoprId)) continue;
                keysIterator.remove();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LRUMap<K, V>
    extends LinkedHashMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = -7232885382582796665L;
        private int capacity;

        public LRUMap(int capacity) {
            super(capacity, 1.0f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
            return this.size() > this.capacity;
        }

        public Object getMostRecent() {
            Iterator iterator = this.values().iterator();
            Object mostRecent = null;
            while (iterator.hasNext()) {
                mostRecent = iterator.next();
            }
            return mostRecent;
        }
    }

    public final class WindowIDRetriver
    implements HttpSessionBindingListener {
        public static final String PORTLET_SCOPE_PREFIX = "javax.portlet.p.";
        private final String scopeId;
        private String windowID;

        private WindowIDRetriver(String scopeId) {
            this.scopeId = scopeId;
        }

        public void valueBound(HttpSessionBindingEvent event) {
            String name = event.getName();
            if (null == name || 0 == name.length()) {
                throw new FacesException("WindowIDRetriver bind to session without name");
            }
            if (2 != PortletSessionUtil.decodeScope((String)name)) {
                throw new FacesException("WindowIDRetriver bind to APPLICATION_SCOPE. PORTLET_SCOPE is required");
            }
            this.windowID = name.substring(PORTLET_SCOPE_PREFIX.length(), name.indexOf(63));
            if (log.isDebugEnabled()) {
                log.debug((Object)("WindowIDRetriver have been bind to session for a portletbridge window " + this.windowID));
            }
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            PortletStateHolder.this.removeSessionStates(this.scopeId);
        }

        public String getWindowID() {
            return this.windowID;
        }

        public String getScopeId() {
            return this.scopeId;
        }
    }
}

