/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import org.jboss.portletbridge.application.PortletViewState;
import org.jboss.portletbridge.context.ContextAttributesMap;
import org.jboss.portletbridge.context.EnumerationIterator;
import org.jboss.portletbridge.context.PortalActionURL;
import org.jboss.portletbridge.context.PortletBridgeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExternalContext
extends ExternalContext {
    public static final String VIEW_ID_PARAMETER = "org.jboss.portletbridge.VIEWID";
    public static final String NAMESPACE_PARAMETER = "org.jboss.portletbridge.NAMESPACE";
    public static final String ACTION__PARAMETER = "org.jboss.portletbridge.ACTION_URL";
    public static final Object PORTLET_MODE_PARAMETER = "org.jboss.portletbridge.MODE";
    public static final Object PORTLET_NAME_PARAMETER = "org.jboss.portletbridge.NAME";
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String PORTLET_CONFIG_ATTRIBUTE = "org.jboss.portletbridge.CONFIG";
    public static final String INITIAL_REQUEST_ATTRIBUTES_NAMES = "org.jboss.portletbridge.REQUEST_PARAMETERS";
    public static final Object RENDER_POLICY_ATTRIBUTE = "org.jboss.portletbridge.RENDER_POLICY";
    public static final String PORTAL_USER_PRINCIPAL = "org.jboss.portletbridge.USER_PRINCIPAL";
    private Map<String, Object> applicationMap;
    private Map<String, String> initParameterMap;
    private Map<String, String> requestHeaderMap = null;
    private Map<String, String[]> requestHeaderValues;
    private Map<String, Object> requestMap;
    private Map<String, String> requestParameterMap;
    private Map<String, String[]> requestParameterValuesMap;
    private Map<String, Object> sessionMap;
    private Object request;
    private Object response;
    private Object context;
    private boolean hasNavigationRedirect = false;
    protected PortletViewState windowState;
    protected PortletBridgeContext portletBridgeContext;
    public static final String CONVERSATION_ID_PARAMETER = "conversationId";

    boolean isHasNavigationRedirect() {
        return this.hasNavigationRedirect;
    }

    void setHasNavigationRedirect(boolean hasNavigationRedirect) {
        this.hasNavigationRedirect = hasNavigationRedirect;
    }

    public AbstractExternalContext(Object context, Object request, Object response) {
        this.context = context;
        this.request = request;
        this.response = response;
    }

    protected abstract String getNamespace();

    public String encodeNamespace(String name) {
        return this.getNamespace() + name;
    }

    public Map<String, Object> getApplicationMap() {
        if (this.applicationMap == null) {
            this.applicationMap = new ContextAttributesMap<Object>(){

                @Override
                protected Enumeration<String> getEnumeration() {
                    return AbstractExternalContext.this.getContextAttributeNames();
                }

                @Override
                protected Object getAttribute(String name) {
                    return AbstractExternalContext.this.getContextAttribute(name);
                }

                @Override
                protected void setAttribute(String name, Object value) {
                    AbstractExternalContext.this.setContextAttribute(name, value);
                }

                @Override
                protected void removeAttribute(String name) {
                    AbstractExternalContext.this.removeContextAttribute(name);
                }
            };
        }
        return this.applicationMap;
    }

    protected abstract void removeContextAttribute(String var1);

    protected abstract void setContextAttribute(String var1, Object var2);

    protected abstract Object getContextAttribute(String var1);

    protected abstract Enumeration<String> getContextAttributeNames();

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        this.context = context;
        this.applicationMap = null;
        this.initParameterMap = null;
    }

    public Map<String, String> getInitParameterMap() {
        if (this.initParameterMap == null) {
            this.initParameterMap = new ContextAttributesMap<String>(){

                @Override
                protected String getAttribute(String name) {
                    return AbstractExternalContext.this.getInitParameter(name);
                }

                @Override
                protected void setAttribute(String name, String value) {
                    throw new UnsupportedOperationException();
                }

                @Override
                protected Enumeration<String> getEnumeration() {
                    return AbstractExternalContext.this.getInitParametersNames();
                }
            };
        }
        return this.initParameterMap;
    }

    protected abstract Enumeration<String> getInitParametersNames();

    public Object getRequest() {
        return this.request;
    }

    public void setRequest(Object request) {
        this.requestHeaderMap = null;
        this.requestHeaderValues = null;
        this.requestMap = null;
        this.requestParameterMap = null;
        this.requestParameterValuesMap = null;
        this.sessionMap = null;
        this.request = request;
    }

    public Map<String, Object> getRequestCookieMap() {
        return Collections.emptyMap();
    }

    public Map<String, String> getRequestHeaderMap() {
        if (this.requestHeaderMap == null) {
            this.requestHeaderMap = new ContextAttributesMap<String>(){

                @Override
                protected Enumeration<String> getEnumeration() {
                    return AbstractExternalContext.this.getRequestHeaderNames();
                }

                @Override
                protected String getAttribute(String name) {
                    return AbstractExternalContext.this.getRequestHeader(name);
                }

                @Override
                protected void setAttribute(String name, String value) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.requestHeaderMap;
    }

    protected abstract String getRequestHeader(String var1);

    protected abstract Enumeration<String> getRequestHeaderNames();

    public Map<String, String[]> getRequestHeaderValuesMap() {
        if (this.requestHeaderValues == null) {
            this.requestHeaderValues = new ContextAttributesMap<String[]>(){

                @Override
                protected Enumeration<String> getEnumeration() {
                    return AbstractExternalContext.this.getRequestHeaderNames();
                }

                @Override
                protected String[] getAttribute(String name) {
                    return AbstractExternalContext.this.getRequestHeaderValues(name);
                }

                @Override
                protected void setAttribute(String name, String[] value) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.requestHeaderValues;
    }

    protected abstract String[] getRequestHeaderValues(String var1);

    public Map<String, Object> getRequestMap() {
        if (this.requestMap == null) {
            this.requestMap = new ContextAttributesMap<Object>(){

                @Override
                protected Enumeration<String> getEnumeration() {
                    return AbstractExternalContext.this.getRequestAttributeNames();
                }

                @Override
                protected Object getAttribute(String name) {
                    return AbstractExternalContext.this.getRequestAttribute(name);
                }

                @Override
                protected void setAttribute(String name, Object value) {
                    AbstractExternalContext.this.setRequestAttribute(name, value);
                }

                @Override
                protected void removeAttribute(String name) {
                    AbstractExternalContext.this.removeRequestAttribute(name);
                }
            };
        }
        return this.requestMap;
    }

    protected abstract void removeRequestAttribute(String var1);

    protected abstract void setRequestAttribute(String var1, Object var2);

    protected abstract Object getRequestAttribute(String var1);

    protected abstract Enumeration<String> getRequestAttributeNames();

    public Map<String, String> getRequestParameterMap() {
        if (this.requestParameterMap == null) {
            this.requestParameterMap = new ContextAttributesMap<String>(){

                @Override
                protected Enumeration<String> getEnumeration() {
                    return AbstractExternalContext.this.enumerateRequestParameterNames();
                }

                @Override
                protected String getAttribute(String name) {
                    return AbstractExternalContext.this.getRequestParameter(name);
                }

                @Override
                protected void setAttribute(String name, String value) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.requestParameterMap;
    }

    protected abstract String getRequestParameter(String var1);

    protected abstract Enumeration<String> enumerateRequestParameterNames();

    public Iterator<String> getRequestParameterNames() {
        return new EnumerationIterator<String>(this.enumerateRequestParameterNames());
    }

    public Map<String, String[]> getRequestParameterValuesMap() {
        if (this.requestParameterValuesMap == null) {
            this.requestParameterValuesMap = new ContextAttributesMap<String[]>(){

                @Override
                protected Enumeration<String> getEnumeration() {
                    return AbstractExternalContext.this.enumerateRequestParameterNames();
                }

                @Override
                protected String[] getAttribute(String name) {
                    return AbstractExternalContext.this.getRequestParameterValues(name);
                }

                @Override
                protected void setAttribute(String name, String[] value) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.requestParameterValuesMap;
    }

    protected abstract String[] getRequestParameterValues(String var1);

    public void setResponse(Object response) {
        this.response = response;
    }

    public Object getResponse() {
        return this.response;
    }

    public Map<String, Object> getSessionMap() {
        if (this.sessionMap == null) {
            this.sessionMap = new ContextAttributesMap<Object>(){

                @Override
                protected Enumeration<String> getEnumeration() {
                    return AbstractExternalContext.this.getSessionAttributeNames();
                }

                @Override
                protected Object getAttribute(String name) {
                    return AbstractExternalContext.this.getSessionAttribute(name);
                }

                @Override
                protected void setAttribute(String name, Object value) {
                    AbstractExternalContext.this.setSessionAttribute(name, value);
                }

                @Override
                protected void removeAttribute(String name) {
                    AbstractExternalContext.this.removeSessionAttribute(name);
                }
            };
        }
        return this.sessionMap;
    }

    protected abstract void removeSessionAttribute(String var1);

    protected abstract void setSessionAttribute(String var1, Object var2);

    protected abstract Object getSessionAttribute(String var1);

    protected abstract Enumeration<String> getSessionAttributeNames();

    protected abstract String createActionUrl(PortalActionURL var1);

    public String encodeActionURL(String url) {
        if (null == url) {
            throw new NullPointerException();
        }
        String actionUrl = url;
        if (!actionUrl.startsWith("#")) {
            try {
                PortalActionURL portalUrl = new PortalActionURL(url);
                String directLink = portalUrl.getParameter("javax.portlet.faces.DirectLink");
                boolean inContext = portalUrl.isInContext(this.getRequestContextPath());
                if (inContext && (null == directLink || !Boolean.parseBoolean(directLink))) {
                    if (null != directLink) {
                        portalUrl.removeParameter("javax.portlet.faces.DirectLink");
                    }
                    return this.createActionUrl(portalUrl);
                }
            }
            catch (MalformedURLException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return this.encodeURL(actionUrl);
    }

    protected abstract String encodeURL(String var1);

    public String encodeResourceURL(String url) {
        try {
            PortalActionURL portalUrl = new PortalActionURL(url);
            boolean inContext = portalUrl.isInContext(this.getRequestContextPath());
            if (inContext) {
                portalUrl.addParameter(NAMESPACE_PARAMETER, this.getNamespace());
                url = portalUrl.toString();
            }
        }
        catch (MalformedURLException e) {
            throw new FacesException((Throwable)e);
        }
        return this.encodeURL(url);
    }
}

