/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalActionURL {
    private static final Pattern urlPattern = Pattern.compile("^(\\w*:)?(//[\\w\\._-]+[^/:])?((?:\\:)(\\d+))?([^?]*)?((?:\\?)(.*))?$");
    private static final String NULL = "";
    private String protocol;
    private String host;
    private int port = -1;
    private String authority;
    private transient String path;
    private transient String userInfo;
    private Map<String, String> parameters;
    private String queryString;
    private int _length;

    public PortalActionURL(String url) throws MalformedURLException {
        Matcher urlMatcher = urlPattern.matcher(url);
        if (!urlMatcher.matches()) {
            throw new MalformedURLException(url);
        }
        this._length = url.length();
        this.protocol = urlMatcher.group(1);
        this.host = urlMatcher.group(2);
        String portStr = urlMatcher.group(4);
        if (null != portStr && portStr.length() > 0) {
            this.port = Integer.parseInt(portStr);
        }
        this.path = urlMatcher.group(5);
        this.queryString = urlMatcher.group(7);
        this.parameters = new LinkedHashMap<String, String>(30);
        if (null != this.queryString) {
            String[] queryParams = this.queryString.split("&");
            for (int i = 0; i < queryParams.length; ++i) {
                String par = queryParams[i];
                int eqIndex = par.indexOf(61);
                if (eqIndex >= 0) {
                    this.parameters.put(par.substring(0, eqIndex), par.substring(eqIndex + 1));
                    continue;
                }
                this.parameters.put(par, NULL);
            }
        }
    }

    public PortalActionURL(PortalActionURL src) {
        if (null == src) {
            throw new NullPointerException("Source URL is null");
        }
        this._length = src._length;
        this.protocol = src.protocol;
        this.host = src.host;
        this.port = src.port;
        this.path = src.path;
        this.queryString = src.queryString;
        this.parameters = new LinkedHashMap<String, String>(src.parameters);
        this.authority = src.authority;
        this.userInfo = src.userInfo;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getPath() {
        return this.path;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public String removeParameter(String name) {
        return this.parameters.remove(name);
    }

    public int parametersSize() {
        return this.parameters.size();
    }

    public boolean isInContext(String context) {
        return this.host == null && this.protocol == null && this.port == -1 && this.path.startsWith(context + "/");
    }

    public String toString() {
        StringBuffer url = new StringBuffer(this._length);
        if (null != this.protocol) {
            url.append(this.protocol);
        }
        if (null != this.host) {
            url.append(this.host);
        }
        if (this.port > 0) {
            url.append(':').append(this.port);
        }
        url.append(this.path);
        if (this.parameters.size() > 0) {
            url.append('?');
            Iterator<Map.Entry<String, String>> iterator = this.parameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> param = iterator.next();
                url.append(param.getKey());
                if (param.getValue() != NULL) {
                    url.append('=').append(param.getValue());
                }
                if (!iterator.hasNext()) continue;
                url.append('&');
            }
        }
        return url.toString();
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }
}

